/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.INameable;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFishingRodOfMisadventure
extends FishingRodItem
implements ISoulConsumer,
IDelayedNBTLoot,
INameable,
ITab {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        super(new Item.Properties().fireResistant());
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        toAdd.accept(new ItemStack((ItemLike)this));
        ItemStack enchantedStack = new ItemStack((ItemLike)this);
        enchantedStack.set(ModDataComponents.ENCHANTED, (Object)true);
        toAdd.accept(enchantedStack);
        toAdd.accept(this.setAncient(enchantedStack.copy()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int speed;
        boolean isEnchanted = this.isEnchanted(stack);
        boolean isAncient = this.isAncient(stack);
        if (Helper.canShowTooltip()) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".desc" + (isEnchanted ? 2 : 1))).setStyle(StyleType.TOOLTIP_DESC));
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".use" + (isEnchanted ? 2 : 1))).setStyle(StyleType.TOOLTIP_USE));
        } else {
            tooltip.add((Component)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"enchantment.tombstone.fishing_bad_luck").append(" ").append(isAncient ? "X" : (isEnchanted ? "V" : "I")).copy().withStyle(ChatFormatting.GRAY));
        int n = isAncient ? 5 : (speed = isEnchanted ? 2 : 0);
        if (speed > 0) {
            this.addEnchantmentFullname(tooltip, (ResourceKey<Enchantment>)Enchantments.LURE, speed);
        }
    }

    public void addEnchantmentFullname(List<Component> tooltip, ResourceKey<Enchantment> enchantmentRK, int enchantmentLevel) {
        ProxyHelper.getClientWorld().ifPresent(level -> tooltip.add(Helper.getEnchantmentFullname(enchantmentRK, enchantmentLevel, level)));
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.plainCopy())).setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ANCIENT, (Object)false) != false;
    }

    public ItemStack setAncient(ItemStack stack) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ANCIENT, (Object)true);
            stack.set(ModDataComponents.SOULBOUND, (Object)true);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean isEnchanted = this.isEnchanted(stack);
        if (player.fishing != null) {
            if (!level.isClientSide()) {
                player.fishing.retrieve(stack);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide()) {
                boolean isAncient = this.isAncient(stack);
                FishingHook fishingHook = new FishingHook(player, level, 0, isAncient ? 5 : (isEnchanted ? 2 : 0));
                fishingHook.luck = -(isAncient ? 100 : (isEnchanted ? 50 : 10));
                level.addFreshEntity((Entity)fishingHook);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getEnchantmentValue();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            stack.setDamageValue(0);
            if (!this.isAncient(stack) && soulStrength > 1) {
                this.setAncient(stack);
                ModTriggers.create_ancient_fishing_rod.trigger(player);
                return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 2);
            }
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    public String getDescriptionId() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String getDescriptionId(ItemStack stack) {
        return this.getDescriptionId();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        this.setAncient(stack).set(ModDataComponents.ENCHANTED, (Object)true);
        return stack;
    }
}

