/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemEasterEggFood
extends ItemGeneric {
    public ItemEasterEggFood() {
        super("easter_egg_food", ItemEasterEggFood.getBuilder().food(new FoodProperties.Builder().nutrition(5).fast().alwaysEdible().build()));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".desc")).setStyle(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        super.finishUsingItem(stack, world, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.preservation, 6000, 0, new boolean[0]);
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.ghostly_shape, 6000, 0, new boolean[0]);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }
}

