/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;

public class ItemEasterEgg
extends ItemGeneric
implements IDelayedNBTLoot {
    public ItemEasterEgg() {
        super("easter_egg", ItemEasterEgg.getBuilder().food(new FoodProperties.Builder().nutrition(2).saturationModifier(2.0f).fast().alwaysEdible().build()));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".desc")).setStyle(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.is((Item)this) && tintIndex == 0) {
            short ordinal;
            return 0xFF000000 | ((ordinal = ((Short)stack.getOrDefault(ModDataComponents.MODEL_COLOR, (Object)Short.valueOf((short)-1))).shortValue()) >= 0 && ordinal < ModelColor.values().length ? ModelColor.values()[ordinal] : ModelColor.values()[0]).color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.MODEL_COLOR, (Object)((short)modelColor.ordinal()));
        }
        return stack;
    }

    public ItemStack getRandomItemStack() {
        return this.getRandomItemStack(1);
    }

    public ItemStack getRandomItemStack(int count) {
        return this.resetColor(new ItemStack((ItemLike)this, count));
    }

    public ItemStack resetColor(ItemStack stack) {
        return this.setColor(stack, ModelColor.getRandom());
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        return this.resetColor(stack);
    }

    public static enum ModelColor {
        PURPLE(5584316),
        GREEN(9034633),
        PINK(0xFF29FF),
        YELLOW(0xFCFF00),
        RED(0xFF2929),
        BLUE(0x2929FF);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.RANDOM.nextInt(ModelColor.values().length)];
        }

        public ItemStack asItemStack() {
            return ModItems.easter_egg.setColor(new ItemStack((ItemLike)ModItems.easter_egg), this);
        }

        public ItemStack asItemStack(int count) {
            return ModItems.easter_egg.setColor(new ItemStack((ItemLike)ModItems.easter_egg, count), this);
        }
    }
}

