/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.item.ItemGift;
import ovh.corail.tombstone.registry.ModTags;

public class ItemBagOfSeeds
extends ItemGift {
    public ItemBagOfSeeds() {
        super("bag_of_seeds", ItemBagOfSeeds.getBuilder().stacksTo(64).fireResistant(), () -> SharedConfigTombstone.allowed_magic_items.allowBagOfSeeds.get());
        this.withDefaultInfo();
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
        }
    }

    @Override
    protected void giveReward(ServerPlayer player, ItemStack heldStack) {
        RandomWeightedItem generator = LootHelper.getItemGenerator(ModTags.Items.seeds);
        IntStream.range(0, Helper.RANDOM.nextInt(3) + 3).forEach(i -> Optional.ofNullable(generator.getRandomItem()).map(seed -> new ItemStack((ItemLike)seed, Helper.RANDOM.nextInt(3) + 1)).ifPresent(s -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)s)));
    }
}

