/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.EnhancedFamiliarHandler;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public class PrayerHelper {
    public static boolean exorcism(ServerPlayer player, LivingEntity target, int alignment) {
        if (target instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)target;
            return Optional.ofNullable((Villager)zombieVillager.convertTo(EntityType.VILLAGER, false)).map(villager -> {
                villager.setVillagerData(zombieVillager.getVillagerData());
                if (zombieVillager.gossips != null) {
                    villager.setGossips(zombieVillager.gossips);
                }
                if (zombieVillager.tradeOffers != null) {
                    villager.setOffers(zombieVillager.tradeOffers.copy());
                }
                villager.setVillagerXp(zombieVillager.getVillagerXp());
                villager.finalizeSpawn((ServerLevelAccessor)player.serverLevel(), player.level().getCurrentDifficultyAt(villager.blockPosition()), MobSpawnType.CONVERSION, null);
                PlayerKnowledgeHandler.rewardKnowledge(player, 3);
                PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get());
                LangKey.MESSAGE_EXORCISM.sendSpecialMessage((Player)player, new Object[0]);
                ModTriggers.exorcism.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static boolean isValidUndead(Entity entity) {
        PathfinderMob target;
        return entity instanceof PathfinderMob && EntityHelper.isUndead((LivingEntity)(target = (PathfinderMob)entity)) && !entity.getType().is(ModTags.EntityTypes.UNHANDLED_TAMABLE_UNDEADS) && !EntityHelper.isBoss((LivingEntity)target);
    }

    public static boolean undead(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < -1 && TamableType.getType(target) == TamableType.UNDEAD && player.level().getDifficulty() != Difficulty.PEACEFUL && TamableType.UNDEAD.getOwnerId(target) == null) {
            PrayerHelper.applyPrayOfUndeadLogic(player, target);
            LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendSpecialMessage((Player)player, new Object[0]);
            ModTriggers.prayer_of_undead.trigger(player);
            return true;
        }
        return false;
    }

    private static void applyPrayOfUndeadLogic(ServerPlayer player, LivingEntity target) {
        ServantUndeadHandler.setOwnerId((Entity)target, player.getGameProfile().getId());
        if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 20) {
            ServantUndeadHandler.setSpellCaster((Entity)target, ServantUndeadHandler.CasterType.getRandomId());
        }
        ServantUndeadHandler.setAI((PathfinderMob)target);
    }

    public static boolean dissonance(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < -2) {
            PrayerHelper.applyPrayOfUndeadLogic(player, target);
            if (EnhancedFamiliarHandler.hasCapability((Entity)target)) {
                EnhancedFamiliarHandler.setEnhanced((Entity)target);
                EnhancedFamiliarHandler.applyAttributes(target);
            }
            LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendSpecialMessage((Player)player, new Object[0]);
            ModTriggers.prayer_of_undead.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean zombify(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < 0 && target instanceof Villager) {
            Villager villager = (Villager)target;
            if (player.level().getDifficulty() != Difficulty.PEACEFUL) {
                return Optional.ofNullable((ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false)).map(zombieVillager -> {
                    zombieVillager.finalizeSpawn((ServerLevelAccessor)player.serverLevel(), player.level().getCurrentDifficultyAt(zombieVillager.blockPosition()), MobSpawnType.CONVERSION, null);
                    zombieVillager.setVillagerData(villager.getVillagerData());
                    zombieVillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                    zombieVillager.setTradeOffers(villager.getOffers().copy());
                    zombieVillager.setVillagerXp(villager.getVillagerXp());
                    ServantUndeadHandler.setOwnerId((Entity)zombieVillager, player.getGameProfile().getId());
                    if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 20) {
                        ServantUndeadHandler.setSpellCaster((Entity)zombieVillager, ServantUndeadHandler.CasterType.getRandomId());
                    }
                    ServantUndeadHandler.setAI((PathfinderMob)zombieVillager);
                    PlayerKnowledgeHandler.rewardKnowledge(player, 3);
                    PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsZombifyVillager.get());
                    LangKey.MESSAGE_EXORCISM.sendSpecialMessage((Player)player, new Object[0]);
                    ModTriggers.zombify.trigger(player);
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    public static boolean empathy(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 1 && PrayerHelper.applyPrayOfEmpathyLogic(player, target)) {
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendSpecialMessage((Player)player, new Object[0]);
            ModTriggers.prayer_of_empathy.trigger(player);
            return true;
        }
        return false;
    }

    private static boolean applyPrayOfEmpathyLogic(ServerPlayer player, LivingEntity target) {
        @Nullable TamableType tamableType = TamableType.getType(target);
        if (tamableType != null && tamableType != TamableType.UNDEAD) {
            tamableType.setTamedBy((Player)player, target);
            if (tamableType == TamableType.TAMABLE) {
                player.level().broadcastEntityEvent((Entity)target, (byte)7);
            }
            return true;
        }
        return false;
    }

    public static boolean harmonization(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 2 && PrayerHelper.applyPrayOfEmpathyLogic(player, target)) {
            if (EnhancedFamiliarHandler.hasCapability((Entity)target)) {
                EnhancedFamiliarHandler.setEnhanced((Entity)target);
                EnhancedFamiliarHandler.applyAttributes(target);
            }
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendSpecialMessage((Player)player, new Object[0]);
            ModTriggers.prayer_of_empathy.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean protection(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 0 && ProtectedEntityHandler.hasCapability((Entity)target) && !ProtectedEntityHandler.isActive((Entity)target)) {
            ProtectedEntityHandler.apply(target, true);
            if (target instanceof ServerPlayer) {
                EntityHelper.syncProtectedPlayerCapability(player);
            }
            PlayerKnowledgeHandler.rewardKnowledge(player, 3);
            PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get());
            LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendSpecialMessage((Player)player, target.getName());
            ModTriggers.pray_of_protection.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean onGrave(ServerPlayer player, BlockPos position) {
        @Nullable BlockPos gravePos = PrayerHelper.findPrayableBlock(player.level(), position);
        if (gravePos != null) {
            EntityType<?> entityType;
            Entity entity;
            PlayerKnowledgeHandler.rewardKnowledge(player, 1);
            ModTriggers.pray_on_grave.trigger(player);
            if (TimeHelper.isAprilFoolsDay()) {
                EffectHelper.addEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.BAD_OMEN, TimeHelper.tickFromDay(1));
            }
            int totalPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            int chancePet = Helper.RANDOM.nextInt(100);
            if (chancePet <= (TimeHelper.isAprilFoolsDay() ? 30 : totalPerkPoints / 5) && (entity = (entityType = TamableType.getRandomTamableEntityType()).create(player.level())) instanceof LivingEntity) {
                LivingEntity familiar = (LivingEntity)entity;
                familiar.setPos((double)((float)gravePos.getX() + Helper.RANDOM.nextFloat()) - 0.5, (double)gravePos.getY() + 1.0, (double)((float)gravePos.getZ() + Helper.RANDOM.nextFloat()) - 0.5);
                Optional.ofNullable(TamableType.getType(familiar)).ifPresent(tamableType -> tamableType.setTamedBy((Player)player, familiar));
                if (familiar instanceof Mob) {
                    ((Mob)familiar).finalizeSpawn((ServerLevelAccessor)player.serverLevel(), player.level().getCurrentDifficultyAt(familiar.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                }
                player.level().addFreshEntity((Entity)familiar);
                LangKey.MESSAGE_SUMMON_FAMILIAR.sendMessage((Player)player, new Object[0]);
            }
            if (TimeHelper.isDateAroundHalloween() || Helper.RANDOM.nextInt(100) <= (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + totalPerkPoints) {
                EffectHelper.addRandomEffect((Player)player, (Integer)SharedConfigTombstone.decorative_grave.prayerCooldown.get() * 120, true, false, false);
            }
            return true;
        }
        LangKey.MESSAGE_CANT_PRAY.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[0]);
        return false;
    }

    @Nullable
    public static BlockPos findPrayableBlock(Level level, BlockPos startPos) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    currentPos.set(startPos.getX() + x, startPos.getY() + y, startPos.getZ() + z);
                    if (!level.getBlockState((BlockPos)currentPos).is(ModTags.Blocks.prayable)) continue;
                    return currentPos.immutable();
                }
            }
        }
        return null;
    }
}

