/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.blockEntity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.blockEntity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBAlignment;
import ovh.corail.tombstone.command.CommandTBGui;
import ovh.corail.tombstone.command.CommandTBKnowledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.entity.SpectralBite;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;

public final class Helper {
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final String APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL = "april_fools_day_slowness";

    public static boolean isDisabledPerk(@Nullable Perk perk, @Nullable Player player) {
        return perk == null || perk.isDisabled(player);
    }

    public static boolean existClass(String className) {
        return Helper.getClass(className) != null;
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static <T> Field getField(@Nullable Class<? super T> aClass, String fieldName) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findField(aClass, (String)fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> aClass, String methodName, Class<?> ... parameterTypes) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findMethod(aClass, (String)methodName, (Class[])parameterTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isModLoad(String modid) {
        return ModList.get() != null && ModList.get().getModContainerById(modid).isPresent();
    }

    public static <T> Optional<T> getRandomInList(Collection<T> list) {
        return list.isEmpty() ? Optional.empty() : list.stream().skip(RANDOM.nextInt(list.size())).findFirst();
    }

    public static <T> Optional<T> getRandomInList(Iterable<T> iterable) {
        return Helper.getRandomInList(StreamSupport.stream(iterable.spliterator(), false).toList());
    }

    public static <T extends Entity> T teleport(T entity, double x, double y, double z, ServerLevel targetWorld) {
        if (entity.level().isClientSide() || !entity.isAlive()) {
            return entity;
        }
        ServerLevel sourceWorld = (ServerLevel)entity.level();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.isSleeping()) {
                player.stopSleepInBed(true, true);
            }
            player.setCamera((Entity)player);
            entity.stopRiding();
            targetWorld.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z)), 1, (Object)player.getId());
            if (targetWorld == player.level()) {
                player.connection.teleport(x, y, z, player.getYRot(), player.getXRot());
            } else {
                player.isChangingDimension = true;
                ServerLevel serverworld = player.serverLevel();
                LevelData levelData = targetWorld.getLevelData();
                player.connection.send((Packet)new ClientboundRespawnPacket(player.createCommonSpawnInfo(targetWorld), 3));
                player.connection.send((Packet)new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
                PlayerList playerList = serverworld.getServer().getPlayerList();
                playerList.sendPlayerPermissionLevel(player);
                serverworld.removePlayerImmediately(player, Entity.RemovalReason.CHANGED_DIMENSION);
                player.revive();
                player.connection.teleport(x, y, z, player.getYRot(), player.getXRot());
                player.connection.resetPosition();
                player.setServerLevel(targetWorld);
                targetWorld.addDuringTeleport((Entity)player);
                player.triggerDimensionChangeTriggers(serverworld);
                player.gameMode.setLevel(targetWorld);
                player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
                playerList.sendLevelInfo(player, targetWorld);
                playerList.sendAllPlayerInfo(player);
                playerList.sendActivePlayerEffects(player);
                player.lastSentExp = -1;
                player.lastSentHealth = -1.0f;
                player.lastSentFood = -1;
                EventHooks.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)serverworld.dimension(), (ResourceKey)targetWorld.dimension());
            }
            return entity;
        }
        entity.unRide();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.isLeashed()) {
                mob.dropLeash(true, false);
            }
            mob.getNavigation().stop();
        }
        if (sourceWorld != targetWorld) {
            return (T)Optional.ofNullable(entity.getType().create((Level)targetWorld)).map(newEntity -> {
                newEntity.restoreFrom(entity);
                newEntity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
                newEntity.setYHeadRot(entity.getYRot());
                newEntity.setDeltaMovement(Vec3.ZERO);
                entity.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.addDuringTeleport(newEntity);
                sourceWorld.resetEmptyTime();
                targetWorld.resetEmptyTime();
                return newEntity;
            }).orElse(entity);
        }
        entity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
        entity.teleportPassengers();
        entity.setYHeadRot(entity.getYRot());
        return entity;
    }

    public static <T extends Entity> T teleport(T entity, Location loc, ServerLevel level) {
        return Helper.teleport(entity, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5, level);
    }

    public static boolean isRuleKeepInventory(@Nullable Entity entity) {
        return entity != null && Helper.isRuleKeepInventory(entity.level());
    }

    public static boolean isRuleKeepInventory(Level level) {
        return level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
    }

    public static boolean canShowTooltip() {
        return (Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || Screen.hasShiftDown();
    }

    public static boolean isAprilFoolsDaySnowball(LivingEntity entity, @Nullable DamageSource source) {
        return TimeHelper.isAprilFoolsDay() && EntityHelper.isValidServerPlayer((Entity)entity) && Optional.ofNullable(source).map(DamageSource::getDirectEntity).map(e -> e.getType() == EntityType.SNOWBALL && e.getPersistentData().contains(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL)).orElse(false) != false;
    }

    public static void handleAprilFoolsDayGrave(Level level, BlockPos pos) {
        Vec3 centerVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 1.0, 0.5);
        Player closestPlayer = level.getNearestPlayer(centerVec.x, centerVec.y, centerVec.z, 20.0, false);
        if (closestPlayer != null) {
            Snowball snowballentity = new Snowball(level, centerVec.x, centerVec.y, centerVec.z);
            if (Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                snowballentity.setItem(new ItemStack((ItemLike)Items.BONE));
                snowballentity.getPersistentData().putBoolean(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL, true);
                Vec3 vec = closestPlayer.position().add(0.0, (double)closestPlayer.getEyeHeight(), 0.0).subtract(snowballentity.position());
                snowballentity.shoot(vec.x, vec.y, vec.z, 1.5f, 1.0f);
                level.addFreshEntity((Entity)snowballentity);
            }
        }
    }

    public static boolean canSeeEntity(Entity entity, Vec3 vec3d) {
        Vec3 vec3d1 = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
        return entity.level().clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isNight(Level level) {
        float angle = level.getTimeOfDay(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean containRL(List<String> listRL, @Nullable ResourceLocation rl) {
        return rl != null && Helper.containRL(listRL, rl.getNamespace(), rl.getPath());
    }

    public static boolean containRL(List<String> listRL, String domain, String path) {
        return listRL.stream().anyMatch(p -> p.contains(":") ? p.equals(domain + ":" + path) : p.equals(domain));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static float[] getRGBColor4F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return rgb;
    }

    public static int combineColor(int ... colors) {
        int r = Mth.floor((double)Arrays.stream(colors).map(c -> c >> 16 & 0xFF).average().orElse(255.0));
        int g = Mth.floor((double)Arrays.stream(colors).map(c -> c >> 8 & 0xFF).average().orElse(255.0));
        int b = Mth.floor((double)Arrays.stream(colors).map(c -> c & 0xFF).average().orElse(255.0));
        return r << 16 | g << 8 | b;
    }

    public static int convertColorToInt(float a, float r, float g, float b) {
        return Math.round(a * 255.0f) << 24 | Math.round(r * 255.0f) << 16 | Math.round(g * 255.0f) << 8 | Math.round(b * 255.0f);
    }

    public static double getDistance(Vec3i vec1, Vec3i vec2) {
        return Math.sqrt(Helper.getDistanceSq(vec1, vec2));
    }

    public static double getDistanceSq(Vec3i vec1, Vec3i vec2) {
        return Helper.getDistanceSq(vec1, vec2.getX(), vec2.getY(), vec2.getZ());
    }

    public static double getDistanceSq(Vec3i vec1, int x2, int y2, int z2) {
        return vec1.distToLowCornerSqr((double)x2, (double)y2, (double)z2);
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static String capitalizeWord(String text) {
        StringBuilder builder = new StringBuilder();
        String[] splits = text.toLowerCase(Locale.US).split("\\s|_");
        builder.append(StringUtils.capitalize((String)splits[0]));
        if (splits.length > 1) {
            Arrays.stream(splits, 1, splits.length).forEach(word -> builder.append(" ").append(StringUtils.capitalize((String)word)));
        }
        return builder.toString();
    }

    public static void initCommands(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext buildContext) {
        new CommandTBAcceptTeleport().registerCommand(commandDispatcher, buildContext);
        new CommandTBGui().registerCommand(commandDispatcher, buildContext);
        new CommandTBKnowledge().registerCommand(commandDispatcher, buildContext);
        new CommandTBAlignment().registerCommand(commandDispatcher, buildContext);
        new CommandTBRecovery().registerCommand(commandDispatcher, buildContext);
        new CommandTBRequestTeleport().registerCommand(commandDispatcher, buildContext);
        new CommandTBRestoreInventory().registerCommand(commandDispatcher, buildContext);
        new CommandTBReviveFamiliar().registerCommand(commandDispatcher, buildContext);
        new CommandTBShowLastGrave().registerCommand(commandDispatcher, buildContext);
        new CommandTBSiege().registerCommand(commandDispatcher, buildContext);
        new CommandTBTeleport().registerCommand(commandDispatcher, buildContext);
    }

    public static void spawnRandomMob(ServerLevel level, BlockPos pos) {
        Location spawnPos = new SpawnHelper(level, new BlockPos(pos.getX() + RANDOM.nextInt(19) - 9, pos.getY(), pos.getZ() + RANDOM.nextInt(19) - 9)).findSafePlace(2, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        Zombie mob = (Zombie)EntityType.ZOMBIE.create((Level)level);
        if (mob != null) {
            mob.setBaby(true);
            if (TimeHelper.isDateAroundHalloween()) {
                mob.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.PUMPKIN));
            }
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.TRIGGERED, null);
            mob.moveTo((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, level.random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntityWithPassengers((Entity)mob);
        }
    }

    public static AABB createBounds(BlockPos pos, double range) {
        return new AABB((double)pos.getX() - range, (double)pos.getY() - range, (double)pos.getZ() - range, (double)pos.getX() + range, (double)pos.getY() + range, (double)pos.getZ() + range);
    }

    public static Optional<BlockEntityDecorativeGrave> getDecorativeGrave(Level level, BlockPos pos) {
        return level.getBlockEntity(pos, ModBlocks.tile_decorative_grave);
    }

    public static Optional<BlockEntityPlayerGrave> getPlayerGrave(Level level, BlockPos pos) {
        return level.getBlockEntity(pos, ModBlocks.tile_grave);
    }

    public static List<ItemStack> getStacks(TagKey<Item> tagKey) {
        return Helper.getItems(tagKey).stream().map(ItemStack::new).collect(Collectors.toList());
    }

    public static List<Holder<Item>> getItems(TagKey<Item> tagKey) {
        return StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(tagKey).spliterator(), false).collect(Collectors.toList());
    }

    public static void castSpectralBite(LivingEntity caster, @Nullable Entity target, int damage, boolean isSpectral) {
        block5: {
            if (target == null || !target.isAlive()) break block5;
            double d0 = Math.min(target.getY(), caster.getY());
            double d1 = Math.max(target.getY(), caster.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(target.getZ() - caster.getZ()), (double)(target.getX() - caster.getX()));
            if (caster.distanceToSqr(target) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    Helper.createSpellEntity(caster, caster.getX() + (double)Mth.cos((float)f1) * 1.5, caster.getZ() + (double)Mth.sin((float)f1) * 1.5, d0, d1, f1, 0, damage, isSpectral);
                }
                for (int j = 0; j < 8; ++j) {
                    float f2 = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    Helper.createSpellEntity(caster, caster.getX() + (double)Mth.cos((float)f2) * 2.5, caster.getZ() + (double)Mth.sin((float)f2) * 2.5, d0, d1, f2, 3, damage, isSpectral);
                }
            } else {
                for (int k = 0; k < 16; ++k) {
                    double d2 = 1.25 * (double)(k + 1);
                    Helper.createSpellEntity(caster, caster.getX() + (double)Mth.cos((float)f) * d2, caster.getZ() + (double)Mth.sin((float)f) * d2, d0, d1, f, k, damage, isSpectral);
                }
            }
        }
    }

    private static void createSpellEntity(LivingEntity caster, double x, double z, double minY, double maxY, float f, int warmupDelayTicks, int damage, boolean isSpectral) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = caster.level().getBlockState(blockpos1);
            if (!blockstate.isFaceSturdy((BlockGetter)caster.level(), blockpos1, Direction.UP)) continue;
            if (!caster.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = caster.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)caster.level(), blockpos)).isEmpty()) {
                d0 = voxelshape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            Cloud cloud;
            SpectralBite spectralBite = new SpectralBite(caster.level(), x, (double)blockpos.getY() + d0, z, f, warmupDelayTicks, caster);
            spectralBite.setDamage(damage);
            spectralBite.setSpectral(isSpectral);
            if (isSpectral && (cloud = (Cloud)ModEntities.cloud.create(caster.level())) != null) {
                cloud.setColor(2404516);
                cloud.setPos(x, (double)blockpos.getY() + d0, z);
                cloud.setLifetime(10);
                caster.level().addFreshEntity((Entity)cloud);
            }
            caster.level().addFreshEntity((Entity)spectralBite);
        }
    }

    public static String getRomanNumber(int number) {
        if (number == 0) {
            return "0";
        }
        List<RomanNumeral> romanNumerals = Arrays.stream(RomanNumeral.values()).sorted(Comparator.comparing(e -> e.value).reversed()).toList();
        int i = 0;
        StringBuilder builder = new StringBuilder();
        while (number > 0 && i < romanNumerals.size()) {
            RomanNumeral symbol = romanNumerals.get(i);
            if (symbol.value <= number) {
                builder.append(symbol.name());
                number -= symbol.value;
                continue;
            }
            ++i;
        }
        return builder.toString();
    }

    public static void spawnGraveGuardian(Level level, BlockPos pos) {
        GraveGuardian graveGuardian = (GraveGuardian)ModEntities.grave_guardian.create(level);
        if (graveGuardian != null) {
            graveGuardian.setPos(pos.getX(), pos.getY(), pos.getZ());
            graveGuardian.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.TRIGGERED, null);
            level.addFreshEntity((Entity)graveGuardian);
        }
    }

    @Nullable
    public static SpectralWolf spawnSpectralWolf(Level level, BlockPos pos, int lifetime, @Nullable Player owner) {
        SpectralWolf spectralWolf = (SpectralWolf)ModEntities.spectral_wolf.create(level);
        if (spectralWolf != null) {
            spectralWolf.setPos(pos.getX(), pos.getY(), pos.getZ());
            spectralWolf.setLifetime(lifetime);
            spectralWolf.setOwner(owner);
            spectralWolf.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.TRIGGERED, null);
            level.addFreshEntity((Entity)spectralWolf);
        }
        return spectralWolf;
    }

    public static ItemStack createEnchantedBook(RegistryAccess registryAccess, ResourceKey<Enchantment> enchantmentRK, int enchantmentLevel) {
        Registry enchantmentRegistry = registryAccess.registryOrThrow(Registries.ENCHANTMENT);
        Holder enchantmentHolder = (Holder)enchantmentRegistry.getHolder(enchantmentRK).orElse(enchantmentRegistry.getHolderOrThrow(ModEnchantments.soulbound));
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantmentHolder, enchantmentLevel));
    }

    public static Component getEnchantmentFullname(ResourceKey<Enchantment> enchantmentRK, int enchantmentLevel, Level level) {
        return ModEnchantments.getEnchantmentHolder(enchantmentRK, level).map(enchHolder -> Enchantment.getFullname((Holder)enchHolder, (int)enchantmentLevel)).orElse((Component)Component.empty());
    }

    public static int getEnchantmentLevelForItem(ResourceKey<Enchantment> enchantmentRK, ItemStack stack, Level level) {
        return ModEnchantments.getEnchantmentHolder(enchantmentRK, level).map(e -> EnchantmentHelper.getItemEnchantmentLevel((Holder)e, (ItemStack)stack)).orElse(0);
    }

    public static boolean hasEnchantmentForItem(ResourceKey<Enchantment> enchantmentRK, ItemStack stack, Level level) {
        return Helper.getEnchantmentLevelForItem(enchantmentRK, stack, level) > 0;
    }

    public static boolean hasSanctifiedEnchantment(LivingEntity livingEntity) {
        ItemStack mainHandStack = livingEntity.getMainHandItem();
        return !mainHandStack.isEmpty() && Helper.getEnchantmentLevelForItem(ModEnchantments.sanctified, mainHandStack, livingEntity.level()) > 0;
    }

    public static boolean isSoulbound(ItemStack stack, Level level) {
        return (Boolean)stack.getOrDefault(ModDataComponents.SOULBOUND, (Object)false) != false || Helper.hasEnchantmentForItem(ModEnchantments.soulbound, stack, level);
    }

    public static ItemEnchantments getRandomEnchantments(int roll, ItemStack stack, int enchantmentCount, Level level) {
        ArrayList<EnchantmentInstance> availableEnchantments = new ArrayList<EnchantmentInstance>();
        boolean isSoulbound = (Boolean)stack.getOrDefault(ModDataComponents.SOULBOUND, (Object)false);
        List list = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().toList();
        block0: for (Holder.Reference enchantmentHolder : list) {
            int maxLevel;
            if (isSoulbound && enchantmentHolder.key() == ModEnchantments.soulbound) continue;
            Enchantment enchantment = (Enchantment)enchantmentHolder.value();
            if (enchantmentHolder.is(EnchantmentTags.CURSE)) continue;
            for (int i = maxLevel = enchantment.getMaxLevel(); i >= enchantment.getMinLevel(); --i) {
                if (roll < enchantment.getMinCost(i) || i != maxLevel && roll > enchantment.getMaxCost(i)) continue;
                availableEnchantments.add(new EnchantmentInstance((Holder)enchantmentHolder, i));
                continue block0;
            }
        }
        ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (!availableEnchantments.isEmpty()) {
            for (int i = 0; i < enchantmentCount && !availableEnchantments.isEmpty(); ++i) {
                WeightedRandom.getRandomItem((RandomSource)RANDOM_SOURCE, availableEnchantments).ifPresent(enchantmentInstance -> {
                    itemEnchantments.set(enchantmentInstance.enchantment, enchantmentInstance.level);
                    availableEnchantments.removeIf(e -> !Enchantment.areCompatible((Holder)e.enchantment, (Holder)enchantmentInstance.enchantment));
                });
            }
        }
        return itemEnchantments.toImmutable();
    }

    public static VoxelShape createShapeForDirection(Direction direction, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (direction) {
            case Direction.SOUTH -> Shapes.box((double)x1, (double)y1, (double)(1.0 - z2), (double)x2, (double)y2, (double)(1.0 - z1));
            case Direction.WEST -> Shapes.box((double)z1, (double)y1, (double)x1, (double)z2, (double)y2, (double)x2);
            case Direction.EAST -> Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2);
            default -> Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        };
    }

    public static boolean hasDataComponentPatch(DataComponentPatch checkedComponentPatch, DataComponentPatch requiredComponentPatch) {
        return checkedComponentPatch.entrySet().containsAll(requiredComponentPatch.entrySet());
    }

    public static void hurtWithoutCooldown(LivingEntity target, DamageSource damageSource, float amount) {
        int oldInvulnerableTime = target.invulnerableTime;
        target.invulnerableTime = 0;
        target.hurt(damageSource, amount);
        target.invulnerableTime = oldInvulnerableTime;
    }

    private static enum RomanNumeral {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;

        private RomanNumeral(int value) {
            this.value = value;
        }
    }
}

