/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.ProxyHelper;

@OnlyIn(value=Dist.CLIENT)
public abstract class TBScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/painting/crow.png");
    public static final ResourceLocation FRAME = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/frame.png");
    final int xSize = 230;
    final int ySize = 230;
    int halfWidth;
    int halfHeight;
    int guiLeft;
    int guiTop;
    int guiRight;
    int guiBottom;

    TBScreen(Component titleIn) {
        super(titleIn);
    }

    public void init() {
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        Objects.requireNonNull(this);
        this.guiLeft = (this.width - 230) / 2;
        Objects.requireNonNull(this);
        this.guiTop = (this.height - 230) / 2;
        Objects.requireNonNull(this);
        this.guiRight = this.guiLeft + 230;
        Objects.requireNonNull(this);
        this.guiBottom = this.guiTop + 230;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        guiGraphics.fill(this.guiLeft - 3, this.guiTop - 3, this.guiLeft + 230 + 3, this.guiTop + 230 + 3, -1);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        guiGraphics.blit(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, 230, 230, 230, 230);
    }

    Player getThePlayer() {
        return ProxyHelper.getClientPlayer().orElse(null);
    }
}

