/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.IOption;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.RenderHelper;
import ovh.corail.tombstone.helper.StyleType;

@OnlyIn(value=Dist.CLIENT)
public class CustomOptionsRowList
extends ContainerObjectSelectionList<Row>
implements ScreenConfig.IHideable {
    private static Runnable tooltip = null;
    public boolean active = false;

    public CustomOptionsRowList(int x, int y, int width, int height, int widgetHeight, IOption ... options) {
        super(Minecraft.getInstance(), width * 2, height, 50, 16);
        this.centerListVertically = false;
        this.setRenderHeader(false, 0);
        Arrays.stream(options).forEach(o -> this.addEntry((AbstractSelectionList.Entry)new Row(this, (IOption)o)));
    }

    protected void renderListBackground(GuiGraphics graphics) {
    }

    protected void renderListSeparators(GuiGraphics graphics) {
    }

    public int getRowWidth() {
        return 190;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_94697_) {
        return this.active && super.mouseClicked(mouseX, mouseY, p_94697_);
    }

    protected int getScrollbarPosition() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + (int)(90.0 * Minecraft.getInstance().getWindow().getGuiScale());
    }

    public static void displayTooltip() {
        if (tooltip != null) {
            tooltip.run();
            tooltip = null;
        }
    }

    @Override
    public void show() {
        this.active = true;
        for (Row row : this.children()) {
            for (AbstractWidget widget : row.widgets) {
                if (widget == null) continue;
                widget.visible = true;
                widget.active = true;
            }
        }
    }

    @Override
    public void hide() {
        this.active = false;
        for (Row row : this.children()) {
            for (AbstractWidget widget : row.widgets) {
                if (widget == null) continue;
                widget.visible = false;
                widget.active = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Row
    extends ContainerObjectSelectionList.Entry<Row> {
        private final List<AbstractWidget> widgets;

        private Row(CustomOptionsRowList this$0, List<AbstractWidget> widgetsIn) {
            this.widgets = widgetsIn;
        }

        public Row(CustomOptionsRowList this$0, IOption option) {
            this(this$0, (List<AbstractWidget>)ImmutableList.of((Object)option.createButton(Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 95, 0, this$0.getRowWidth())));
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int p_230432_4_, int p_230432_5_, int p_230432_6_, int mouseX, int mouseY, boolean isHover, float partialTicks) {
            this.widgets.forEach(widget -> {
                widget.setY(y);
                widget.setHeight(14);
                boolean isHovered = this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard() || mouseX >= widget.getX() && mouseY >= widget.getY() && mouseX < widget.getX() + widget.getWidth() && mouseY < widget.getY() + widget.getHeight();
                RenderHelper.fillGradient(guiGraphics.pose().last().pose(), widget.getX() + 1, widget.getY() + 1, widget.getX() + widget.getWidth() - 2, widget.getY() + widget.getHeight() - 2, isHovered ? -14668449 : 0x70000000, isHovered ? -14668449 : 0x30000000, -50, true);
                float alpha = 1.0f;
                FontHelper.drawCenteredFantasy(guiGraphics, Minecraft.getInstance().font, (Component)Component.literal((String)Helper.capitalizeWord(widget.getMessage().getString())), (float)widget.getX() + (float)widget.getWidth() / 2.0f, (float)widget.getY() + (float)(widget.getHeight() - 8) / 2.0f, (widget.active ? (isHovered ? -1875 : -1) : 0) | Mth.ceil((float)(alpha * 255.0f)) << 24);
                if (isHovered) {
                    tooltip = () -> {
                        Minecraft mc = Minecraft.getInstance();
                        MutableComponent info = Component.translatable((String)("tombstone.config." + widget.getMessage().getString().split(":")[0] + ".tooltip")).setStyle(StyleType.TOOLTIP_HOVER);
                        int start = widget.getX() + widget.getWidth();
                        int boxWidth = Math.min(mc.font.width((FormattedText)info) + 4, mc.getWindow().getGuiScaledWidth() - start - 4);
                        this.drawInBox(guiGraphics, FontHelper.withFantasyFont((Component)info), start, widget.getY() + widget.getHeight() / 2, boxWidth, mc.font);
                    };
                }
            });
        }

        private void drawInBox(GuiGraphics guiGraphics, Component content, int x, int y, int boxWidth, Font font) {
            List toDisplay = font.split((FormattedText)content, boxWidth);
            Objects.requireNonNull(font);
            int boxHeight = 9 * toDisplay.size() + 2;
            int startY = y - boxHeight / 2;
            guiGraphics.fill(x - 1, startY - 1, x + boxWidth + 1, startY + boxHeight + 1, -14668449);
            guiGraphics.fill(x, startY, x + boxWidth, startY + boxHeight, Integer.MIN_VALUE);
            for (int i = 0; i < toDisplay.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)toDisplay.get(i);
                float f = (float)x + (float)boxWidth / 2.0f;
                Objects.requireNonNull(font);
                FontHelper.drawCentered(guiGraphics, font, formattedCharSequence, f, (float)(startY + 2 + i * 9), -1875);
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }
    }
}

