/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.item.ItemEasterEgg;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class CompendiumData {
    private static final int LINES_BY_PAGE = 13;
    private static final int DESCRIPTION_WIDTH = 210;
    private final CompendiumLabel info;
    private final ItemStack icon;
    private final List<FormattedCharSequence> description;
    private final int pageMax;
    private final List<CompendiumLabel> links;

    CompendiumData(CompendiumLabel info, ItemStack icon, Component description, List<CompendiumLabel> links) {
        this.info = info;
        this.icon = icon;
        this.description = Minecraft.getInstance().font.split((FormattedText)FontHelper.withFantasyFont(description), 210);
        this.pageMax = Mth.ceil((float)((float)this.description.size() / 13.0f));
        this.links = links;
    }

    boolean isIndex() {
        return this.info == CompendiumLabel.COMPENDIUM;
    }

    ItemStack getIcon() {
        return this.icon;
    }

    Component getTitle() {
        return this.info.getTitle();
    }

    List<FormattedCharSequence> getPage(int pageNum) {
        int indexStart = Math.min(pageNum * 13, this.description.size() - 1);
        if (indexStart >= 0) {
            return this.description.subList(indexStart, Math.min(indexStart + 13 - 1, this.description.size() - 1) + 1);
        }
        return Collections.emptyList();
    }

    int getPageMax() {
        return this.pageMax;
    }

    List<CompendiumLabel> getLinks() {
        return this.links;
    }

    static CompendiumData getInfo(CompendiumLabel info) {
        Builder builder = new Builder(info);
        switch (info.ordinal()) {
            case 17: {
                builder.withIcon((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE)).withDescription("tombstone.compendium.intro");
                break;
            }
            case 73: {
                builder.withIcon((ItemLike)Items.HEART_OF_THE_SEA).withDescriptionAsText("Special thanks to some people for past discussions that helped in the creation and evolution of this mod:\n- Gegy\n- Tterag\n- KidsDontPlay\n- Runemoro\n- Barteks2x\n- H3lay");
                break;
            }
            case 20: {
                builder.withIcon(ItemAdvancement.IconType.FIRST_KNOWLEDGE);
                break;
            }
            case 19: {
                builder.withIcon((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.GRAVE_SIMPLE));
                break;
            }
            case 16: {
                builder.withIcon(ItemAdvancement.IconType.COMBINATION);
                break;
            }
            case 44: {
                builder.withIcon(ItemAdvancement.IconType.TELEPORT_TO_GRAVE);
                break;
            }
            case 23: {
                builder.withIcon((ItemLike)Items.ENCHANTED_BOOK);
                break;
            }
            case 50: {
                builder.withIcon(ItemAdvancement.IconType.TELEPORT_TO_GRAVE);
                break;
            }
            case 36: {
                builder.withIcon((ItemLike)ModItems.ankh_of_prayer);
                break;
            }
            case 72: {
                break;
            }
            case 3: 
            case 18: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: {
                builder.withIcon((ItemLike)Items.ENCHANTED_BOOK);
                break;
            }
            case 0: {
                builder.withIcon(ItemAdvancement.IconType.REVIVE);
                break;
            }
            case 1: {
                builder.withIcon((ItemLike)ModItems.ankh_of_prayer);
                break;
            }
            case 4: {
                builder.withIcon((ItemLike)ModItems.bone_needle);
                break;
            }
            case 5: {
                builder.withIcon((ItemLike)ModItems.book_of_disenchantment);
                break;
            }
            case 6: {
                builder.withIcon((ItemLike)ModItems.book_of_recycling);
                break;
            }
            case 7: {
                builder.withIcon((ItemLike)ModItems.book_of_repairing);
                break;
            }
            case 8: {
                builder.withIcon((ItemLike)ModItems.book_of_scribe);
                break;
            }
            case 9: {
                builder.withIcon((ItemLike)ModItems.book_of_magic_impregnation);
                break;
            }
            case 10: {
                builder.withIcon((ItemLike)ModItems.book_of_soulbound);
                break;
            }
            case 11: {
                builder.withIcon((ItemLike)ModItems.book_of_oblivion);
                break;
            }
            case 43: {
                builder.withIcon((ItemLike)Items.BOOKSHELF);
                break;
            }
            case 32: {
                builder.withIcon((ItemLike)ModBlocks.dark_marble);
                break;
            }
            case 21: {
                builder.withIcon((ItemLike)ModItems.dust_of_vanishing);
                break;
            }
            case 22: {
                builder.withIcon((ItemLike)ModItems.dust_of_frost);
                break;
            }
            case 24: {
                builder.withIcon((ItemLike)ModItems.essence_of_undeath);
                break;
            }
            case 25: {
                builder.withIcon((ItemLike)ModItems.receptacle_of_familiar);
                break;
            }
            case 26: {
                builder.withIcon((ItemLike)ModItems.fishing_rod_of_misadventure);
                break;
            }
            case 28: {
                builder.withIcon(ItemAdvancement.IconType.CANCEL_GHOSTLY_SHAPE);
                break;
            }
            case 29: {
                builder.withIcon((ItemLike)ModItems.grave_dust);
                break;
            }
            case 31: {
                builder.withIcon((ItemLike)ModItems.grave_key);
                break;
            }
            case 33: {
                builder.withIcon(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "named"));
                break;
            }
            case 34: {
                builder.withIcon(ItemAdvancement.IconType.GHOST);
                break;
            }
            case 2: {
                builder.withIcon((ItemLike)Items.TROPICAL_FISH);
                break;
            }
            case 12: {
                ItemStack gift = new ItemStack((ItemLike)ModItems.gift);
                gift.set(ModDataComponents.ENCHANTED, (Object)true);
                builder.withIcon(gift);
                break;
            }
            case 14: {
                builder.withIcon((ItemLike)ModItems.christmas_gift);
                break;
            }
            case 15: {
                builder.withIcon((ItemLike)ModItems.villager_gift);
                break;
            }
            case 13: {
                builder.withIcon((ItemLike)ModItems.christmas_hat);
                break;
            }
            case 35: {
                builder.withIcon((ItemLike)ModItems.impregnated_diamond);
                break;
            }
            case 37: {
                builder.withIcon(ModItems.lollipop.getRandomItemStack());
                break;
            }
            case 38: {
                builder.withIcon(ItemEasterEgg.ModelColor.BLUE.asItemStack());
                break;
            }
            case 39: {
                builder.withIcon(ItemEasterEgg.ModelColor.RED.asItemStack());
                break;
            }
            case 40: {
                builder.withIcon((ItemLike)ModItems.easter_egg_food);
                break;
            }
            case 41: {
                builder.withIcon((ItemLike)ModItems.rabbit_mask);
                break;
            }
            case 42: {
                builder.withIcon((ItemLike)ModItems.lost_tablet);
                break;
            }
            case 48: {
                break;
            }
            case 54: {
                builder.withIcon(ItemScrollBuff.SpellBuff.FEATHER_FALL);
                break;
            }
            case 56: {
                builder.withIcon((ItemLike)ModItems.scroll_of_knowledge);
                break;
            }
            case 59: {
                builder.withIcon(ItemScrollBuff.SpellBuff.PRESERVATION);
                break;
            }
            case 61: {
                builder.withIcon(ItemScrollBuff.SpellBuff.PURIFICATION);
                break;
            }
            case 63: {
                builder.withIcon(ItemScrollBuff.SpellBuff.TRUE_SIGHT);
                break;
            }
            case 64: {
                builder.withIcon(ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY);
                break;
            }
            case 62: {
                builder.withIcon(ItemScrollBuff.SpellBuff.REACH);
                break;
            }
            case 57: {
                builder.withIcon(ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE);
                break;
            }
            case 55: {
                builder.withIcon(ItemScrollBuff.SpellBuff.FROST_RESISTANCE);
                break;
            }
            case 53: {
                builder.withIcon(ItemScrollBuff.SpellBuff.AQUATIC_LIFE);
                break;
            }
            case 58: {
                builder.withIcon(ItemScrollBuff.SpellBuff.MERCY);
                break;
            }
            case 60: {
                builder.withIcon(ItemScrollBuff.SpellBuff.PROJECTILE_REFLECTION);
                break;
            }
            case 45: {
                builder.withIcon((ItemLike)ModItems.strange_scroll);
                break;
            }
            case 30: {
                builder.withIcon((ItemLike)Items.SKELETON_SKULL);
                break;
            }
            case 69: {
                builder.withIcon(ItemAdvancement.IconType.ACTIVATE_MAGIC_ITEM);
                break;
            }
            case 70: {
                builder.withIcon((ItemLike)ModItems.receptacle_of_soul);
                break;
            }
            case 74: {
                builder.withIcon((ItemLike)ModItems.strange_scroll);
                break;
            }
            case 75: {
                builder.withIcon((ItemLike)ModItems.strange_tablet);
                break;
            }
            case 78: {
                builder.withIcon((ItemLike)ModItems.tablet_of_home);
                break;
            }
            case 79: {
                builder.withIcon((ItemLike)ModItems.tablet_of_recall);
                break;
            }
            case 76: {
                builder.withIcon((ItemLike)ModItems.tablet_of_assistance);
                break;
            }
            case 77: {
                builder.withIcon((ItemLike)ModItems.tablet_of_cupidity);
                break;
            }
            case 80: {
                builder.withIcon((ItemLike)ModItems.tablet_of_guard);
                break;
            }
            case 47: {
                builder.withIcon((ItemLike)ModItems.strange_tablet);
                break;
            }
            case 81: {
                builder.withIcon((ItemLike)ModItems.voodoo_poppet);
            }
        }
        switch (info.ordinal()) {
            case 17: {
                builder.withLinks(CompendiumLabel.DEATH, CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.COMBINATION, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.ENCHANTMENTS, CompendiumLabel.PRAYER, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.SPECIAL_THANKS);
                break;
            }
            case 0: {
                builder.withLinks(CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.PRAYER);
                break;
            }
            case 1: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.ALIGNMENT, CompendiumLabel.PRAYER);
                break;
            }
            case 4: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.RECEPTACLE_OF_FAMILIAR);
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.GRAVE_DUST);
                break;
            }
            case 20: {
                builder.withLinks(CompendiumLabel.GHOSTLY_SHAPE, CompendiumLabel.GRAVE_KEY, CompendiumLabel.PERK);
                break;
            }
            case 19: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.GRAVE_PLATE, CompendiumLabel.ESSENCE_OF_UNDEATH, CompendiumLabel.GRAVE_GUARDIAN, CompendiumLabel.PRAYER);
                break;
            }
            case 21: 
            case 22: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case 23: {
                builder.withLinks(CompendiumLabel.SPECTRAL_BITE, CompendiumLabel.SOULBOUND, CompendiumLabel.MAGIC_SIPHON, CompendiumLabel.PLAGUE_BRINGER, CompendiumLabel.CURSE_OF_BONES, CompendiumLabel.BLESSING, CompendiumLabel.FROSTBITE, CompendiumLabel.SPECTRAL_CONJURER, CompendiumLabel.INCURABLE_WOUNDS, CompendiumLabel.DECREPITUDE, CompendiumLabel.SANCTIFIED, CompendiumLabel.RUTHLESS_STRIKE, CompendiumLabel.BOOK_OF_MAGIC_IMPREGNATION);
                break;
            }
            case 3: 
            case 18: 
            case 27: 
            case 46: 
            case 49: 
            case 51: 
            case 52: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                builder.withLinks(CompendiumLabel.ENCHANTMENTS);
                break;
            }
            case 71: {
                builder.withLinks(CompendiumLabel.ENCHANTMENTS, CompendiumLabel.BOOK_OF_SOULBOUND);
                break;
            }
            case 24: 
            case 30: 
            case 33: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE);
                break;
            }
            case 25: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case 26: {
                builder.withLinks(CompendiumLabel.LOST_TABLET, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL);
                break;
            }
            case 28: {
                builder.withLinks(CompendiumLabel.DEATH, CompendiumLabel.VOODOO_POPPET, CompendiumLabel.RECEPTACLE_OF_SOUL);
                break;
            }
            case 29: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.DUST_OF_VANISHING, CompendiumLabel.DUST_OF_FROST, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case 31: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.DEATH, CompendiumLabel.SOUL);
                break;
            }
            case 36: {
                builder.withLinks(CompendiumLabel.ALIGNMENT, CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.SOUL, CompendiumLabel.RECEPTACLE_OF_SOUL);
                break;
            }
            case 35: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case 39: {
                builder.withLinks(CompendiumLabel.EASTER, CompendiumLabel.EASTER_EGG_FOOD);
                break;
            }
            case 40: {
                builder.withLinks(CompendiumLabel.EASTER, CompendiumLabel.EASTER_EGG);
                break;
            }
            case 41: {
                builder.withLinks(CompendiumLabel.EASTER, CompendiumLabel.GRAVE_GUARDIAN);
                break;
            }
            case 37: {
                builder.withLinks(CompendiumLabel.HALLOWEEN, CompendiumLabel.CHRISTMAS, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case 42: {
                builder.withLinks(CompendiumLabel.FISHING_ROD_OF_MISADVENTURE, CompendiumLabel.MAGIC_TABLETS, CompendiumLabel.PERK, CompendiumLabel.SOUL);
                break;
            }
            case 44: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.MAGIC_BOOKS, CompendiumLabel.DUST_OF_VANISHING, CompendiumLabel.DUST_OF_FROST, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.FISHING_ROD_OF_MISADVENTURE, CompendiumLabel.GRAVE_KEY, CompendiumLabel.LOLLIPOP, CompendiumLabel.EASTER_EGG, CompendiumLabel.MAGIC_SCROLLS, CompendiumLabel.MAGIC_TABLETS, CompendiumLabel.RECEPTACLE_OF_SOUL, CompendiumLabel.VOODOO_POPPET);
                break;
            }
            case 43: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.BOOK_OF_DISENCHANTMENT, CompendiumLabel.BOOK_OF_RECYCLING, CompendiumLabel.BOOK_OF_REPAIRING, CompendiumLabel.BOOK_OF_SCRIBE, CompendiumLabel.BOOK_OF_MAGIC_IMPREGNATION, CompendiumLabel.BOOK_OF_SOULBOUND, CompendiumLabel.BOOK_OF_OBLIVION);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                builder.withLinks(CompendiumLabel.MAGIC_BOOKS);
                break;
            }
            case 10: {
                builder.withLinks(CompendiumLabel.MAGIC_BOOKS, CompendiumLabel.SOULBOUND);
                break;
            }
            case 9: {
                builder.withLinks(CompendiumLabel.MAGIC_BOOKS, CompendiumLabel.ENCHANTMENTS);
                break;
            }
            case 45: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.STRANGE_SCROLL, CompendiumLabel.SCROLL_OF_AQUATIC_LIFE, CompendiumLabel.SCROLL_OF_FEATHER_FALL, CompendiumLabel.SCROLL_OF_FROST_RESISTANCE, CompendiumLabel.SCROLL_OF_KNOWLEDGE, CompendiumLabel.SCROLL_OF_LIGHTNING_RESISTANCE, CompendiumLabel.SCROLL_OF_PRESERVATION, CompendiumLabel.SCROLL_OF_PURIFICATION, CompendiumLabel.SCROLL_OF_REACH, CompendiumLabel.SCROLL_OF_TRUE_SIGHT, CompendiumLabel.SCROLL_OF_UNSTABLE_INTANGIBILITY, CompendiumLabel.SCROLL_OF_MERCY, CompendiumLabel.SCROLL_OF_PROJECTILE_REFLECTION);
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                builder.withLinks(CompendiumLabel.MAGIC_SCROLLS);
                break;
            }
            case 74: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_SCROLLS);
                break;
            }
            case 47: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.STRANGE_TABLET, CompendiumLabel.LOST_TABLET, CompendiumLabel.TABLET_OF_ASSISTANCE, CompendiumLabel.TABLET_OF_CUPIDITY, CompendiumLabel.TABLET_OF_HOME, CompendiumLabel.TABLET_OF_RECALL, CompendiumLabel.TABLET_OF_GUARD);
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                builder.withLinks(CompendiumLabel.MAGIC_TABLETS);
                break;
            }
            case 75: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_TABLETS);
                break;
            }
            case 48: {
                builder.withLinks(CompendiumLabel.DEATH, CompendiumLabel.GHOSTLY_SHAPE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case 50: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.ALIGNMENT, CompendiumLabel.DECORATIVE_GRAVE);
                break;
            }
            case 69: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.RECEPTACLE_OF_SOUL);
                break;
            }
            case 70: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.GHOSTLY_SHAPE);
                break;
            }
            case 72: {
                builder.withLinks(CompendiumLabel.HALLOWEEN, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.CHRISTMAS);
                break;
            }
            case 34: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.CHRISTMAS, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.EASTER, CompendiumLabel.LOLLIPOP);
                break;
            }
            case 12: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.HALLOWEEN, CompendiumLabel.EASTER, CompendiumLabel.LOLLIPOP);
                break;
            }
            case 14: 
            case 15: {
                builder.withLinks(CompendiumLabel.CHRISTMAS);
                break;
            }
            case 13: {
                builder.withLinks(CompendiumLabel.CHRISTMAS, CompendiumLabel.GRAVE_GUARDIAN);
                break;
            }
            case 2: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.CHRISTMAS, CompendiumLabel.HALLOWEEN, CompendiumLabel.EASTER);
                break;
            }
            case 38: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.CHRISTMAS, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.HALLOWEEN, CompendiumLabel.EASTER_EGG, CompendiumLabel.EASTER_EGG_FOOD, CompendiumLabel.RABBIT_MASK);
                break;
            }
            case 81: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.GHOSTLY_SHAPE);
            }
        }
        return builder.build();
    }

    public static enum CompendiumLabel {
        ALIGNMENT("tombstone.message.alignment"),
        ANKH_OF_PRAYER("tombstone.item.ankh_of_prayer"),
        APRIL_FOOLS_DAY,
        BLESSING("enchantment.tombstone.blessing"),
        BONE_NEEDLE("tombstone.item.bone_needle"),
        BOOK_OF_DISENCHANTMENT("tombstone.item.book_of_disenchantment"),
        BOOK_OF_RECYCLING("tombstone.item.book_of_recycling"),
        BOOK_OF_REPAIRING("tombstone.item.book_of_repairing"),
        BOOK_OF_SCRIBE("tombstone.item.book_of_scribe"),
        BOOK_OF_MAGIC_IMPREGNATION("tombstone.item.book_of_magic_impregnation"),
        BOOK_OF_SOULBOUND("tombstone.item.book_of_soulbound"),
        BOOK_OF_OBLIVION("tombstone.item.book_of_oblivion"),
        CHRISTMAS,
        CHRISTMAS_HAT("item.tombstone.christmas_hat"),
        CHRISTMAS_GIFT("item.tombstone.christmas_gift"),
        VILLAGER_GIFT("item.tombstone.christmas_villager"),
        COMBINATION,
        COMPENDIUM(LangKey.MESSAGE_COMPENDIUM.getKey()),
        CURSE_OF_BONES("enchantment.tombstone.curse_of_bones"),
        DECORATIVE_GRAVE("tombstone.config_cat.decorative_grave"),
        DEATH,
        DUST_OF_VANISHING("tombstone.item.dust_of_vanishing"),
        DUST_OF_FROST("tombstone.item.dust_of_frost"),
        ENCHANTMENTS,
        ESSENCE_OF_UNDEATH("tombstone.item.essence_of_undeath"),
        RECEPTACLE_OF_FAMILIAR("tombstone.item.receptacle_of_familiar"),
        FISHING_ROD_OF_MISADVENTURE("tombstone.item.fishing_rod_of_misadventure"),
        FROSTBITE("enchantment.tombstone.frostbite"),
        GHOSTLY_SHAPE("effect.tombstone.ghostly_shape"),
        GRAVE_DUST("tombstone.item.grave_dust"),
        GRAVE_GUARDIAN("entity.tombstone.grave_guardian"),
        GRAVE_KEY("tombstone.item.grave_key"),
        GRAVE_MARBLE("tombstone.block.dark_marble"),
        GRAVE_PLATE("tombstone.item.grave_plate"),
        HALLOWEEN,
        IMPREGNATED_DIAMOND("tombstone.item.impregnated_diamond"),
        KNOWLEDGE_OF_DEATH("tombstone.message.knowledge_of_death"),
        LOLLIPOP("tombstone.item.lollipop"),
        EASTER,
        EASTER_EGG("tombstone.item.easter_egg"),
        EASTER_EGG_FOOD("item.tombstone.easter_egg_food"),
        RABBIT_MASK("item.tombstone.rabbit_mask"),
        LOST_TABLET("tombstone.item.lost_tablet"),
        MAGIC_BOOKS,
        MAGIC_ITEMS,
        MAGIC_SCROLLS,
        MAGIC_SIPHON("enchantment.tombstone.magic_siphon"),
        MAGIC_TABLETS,
        PERK,
        PLAGUE_BRINGER("enchantment.tombstone.plague_bringer"),
        PRAYER,
        RUTHLESS_STRIKE("enchantment.tombstone.ruthless_strike"),
        SANCTIFIED("enchantment.tombstone.sanctified"),
        SCROLL_OF_AQUATIC_LIFE("tombstone.item.scroll_of_aquatic_life"),
        SCROLL_OF_FEATHER_FALL("tombstone.item.scroll_of_feather_fall"),
        SCROLL_OF_FROST_RESISTANCE("tombstone.item.scroll_of_frost_resistance"),
        SCROLL_OF_KNOWLEDGE("tombstone.item.scroll_of_knowledge"),
        SCROLL_OF_LIGHTNING_RESISTANCE("tombstone.item.scroll_of_lightning_resistance"),
        SCROLL_OF_MERCY("tombstone.item.scroll_of_mercy"),
        SCROLL_OF_PRESERVATION("tombstone.item.scroll_of_preservation"),
        SCROLL_OF_PROJECTILE_REFLECTION("item.tombstone.scroll_of_projectile_reflection"),
        SCROLL_OF_PURIFICATION("tombstone.item.scroll_of_purification"),
        SCROLL_OF_REACH("tombstone.item.scroll_of_reach"),
        SCROLL_OF_TRUE_SIGHT("tombstone.item.scroll_of_true_sight"),
        SCROLL_OF_UNSTABLE_INTANGIBILITY("tombstone.item.scroll_of_unstable_intangibility"),
        SPECTRAL_BITE("enchantment.tombstone.spectral_bite"),
        SPECTRAL_CONJURER("enchantment.tombstone.spectral_conjurer"),
        INCURABLE_WOUNDS("enchantment.tombstone.incurable_wounds"),
        DECREPITUDE("enchantment.tombstone.decrepitude"),
        SOUL,
        RECEPTACLE_OF_SOUL("tombstone.item.receptacle_of_soul"),
        SOULBOUND("enchantment.tombstone.soulbound"),
        SPECIAL_BONUS,
        SPECIAL_THANKS((Component)Component.literal((String)"Special Thanks")),
        STRANGE_SCROLL("tombstone.item.strange_scroll"),
        STRANGE_TABLET("tombstone.item.strange_tablet"),
        TABLET_OF_ASSISTANCE("tombstone.item.tablet_of_assistance"),
        TABLET_OF_CUPIDITY("tombstone.item.tablet_of_cupidity"),
        TABLET_OF_HOME("tombstone.item.tablet_of_home"),
        TABLET_OF_RECALL("tombstone.item.tablet_of_recall"),
        TABLET_OF_GUARD("tombstone.item.tablet_of_guard"),
        VOODOO_POPPET("tombstone.item.voodoo_poppet");

        private final Component title;

        private CompendiumLabel(String translation) {
            this((Component)Component.translatable((String)translation));
        }

        private CompendiumLabel(Component compo) {
            this.title = compo;
        }

        private CompendiumLabel() {
            this.title = Component.translatable((String)("tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".title"));
        }

        Component getTitle() {
            return FontHelper.withFantasyFont(this.title);
        }

        @Nullable
        public static CompendiumLabel fromString(String label) {
            return Arrays.stream(CompendiumLabel.values()).filter(l -> l.name().equalsIgnoreCase(label)).findFirst().orElse(null);
        }
    }

    static final class Builder {
        private final CompendiumLabel info;
        private ItemStack icon = ItemStack.EMPTY;
        private Component description;
        private List<CompendiumLabel> links = Collections.emptyList();

        Builder(CompendiumLabel info) {
            this.info = info;
            this.description = Component.translatable((String)("tombstone.compendium." + info.name().toLowerCase(Locale.US) + ".desc"));
        }

        Builder withIcon(ItemScrollBuff.SpellBuff spellBuff) {
            return this.withIcon((ItemLike)spellBuff.getItem());
        }

        Builder withIcon(ItemAdvancement.IconType iconType) {
            return this.withIcon(iconType.getItemStack());
        }

        Builder withIcon(ItemLike item) {
            return this.withIcon(new ItemStack((ItemLike)item.asItem()));
        }

        Builder withIcon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        Builder withDescription(String description) {
            this.description = Component.translatable((String)description);
            return this;
        }

        Builder withDescriptionAsText(String description) {
            this.description = Component.literal((String)description);
            return this;
        }

        Builder withLinks(CompendiumLabel ... links) {
            this.links = this.info == CompendiumLabel.COMPENDIUM ? Arrays.stream(links).toList() : Arrays.stream(links).sorted(Comparator.comparing(p -> Normalizer.normalize(p.getTitle().getString(), Normalizer.Form.NFD))).toList();
            return this;
        }

        CompendiumData build() {
            return new CompendiumData(this.info, this.icon, this.description, this.links);
        }
    }
}

