/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEntities;

public record SummonSpectralWolf(LevelBasedValue minDuration, LevelBasedValue maxDuration) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonSpectralWolf> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(SummonSpectralWolf::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(SummonSpectralWolf::maxDuration)).apply((Applicative)c, SummonSpectralWolf::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse itemInUse, Entity entity, Vec3 origin) {
        LivingEntity target;
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).isAlive()) {
            boolean isPlayerOwner = EntityHelper.isValidPlayer((Entity)itemInUse.owner());
            int duration = Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minDuration.calculate(enchantmentLevel), (float)this.maxDuration.calculate(enchantmentLevel)) * 20.0f);
            List spectralWolves = target.level().getEntities((Entity)target, target.getBoundingBox().inflate(2.0, 1.0, 2.0), t -> t.getType() == ModEntities.spectral_wolf && t.isAlive() && (!isPlayerOwner || ((SpectralWolf)((Object)t)).isOwner((Player)itemInUse.owner())));
            if (spectralWolves.isEmpty()) {
                SpectralWolf spectralWolf = Helper.spawnSpectralWolf((Level)level, new BlockPos((int)origin.x, (int)origin.y, (int)origin.z), duration, isPlayerOwner ? (Player)itemInUse.owner() : null);
                if (spectralWolf != null) {
                    spectralWolf.target = target;
                }
            } else {
                SpectralWolf spectralWolf = (SpectralWolf)((Object)spectralWolves.getFirst());
                spectralWolf.increaseLifetime(duration);
                spectralWolf.target = target;
            }
        }
    }

    public MapCodec<SummonSpectralWolf> codec() {
        return CODEC;
    }
}

