/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;

public final class PrayerEffect
extends TombstoneEffect {
    public PrayerEffect() {
        super(MobEffectCategory.NEUTRAL, -16250345);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Player player;
        boolean valid = false;
        CompoundTag persistentData = livingEntity.getPersistentData();
        Optional<UUID> prayerUUID = NBTStackHelper.getUUID(persistentData, "prayer");
        if (prayerUUID.isPresent() && (player = livingEntity.level().getPlayerByUUID(prayerUUID.get())) != null && player.isUsingItem() && player.getMainHandItem().is((Item)ModItems.ankh_of_prayer)) {
            livingEntity.setPos(livingEntity.xOld, livingEntity.yOld, livingEntity.zOld);
            livingEntity.setOnGround(false);
            EntityHelper.resetAttackAction(livingEntity);
            livingEntity.clearFire();
            livingEntity.setDeltaMovement(0.0, 0.005, 0.0);
            if (!livingEntity.level().isClientSide() && livingEntity.tickCount % 40 == 0) {
                ModSounds.playSoundAllAround(ModSounds.magic_use01, SoundSource.PLAYERS, livingEntity.level(), livingEntity.blockPosition(), 0.5f, 0.5f + Helper.RANDOM.nextFloat() * 0.5f);
            }
            valid = true;
        }
        if (!valid) {
            persistentData.remove("prayer");
            persistentData.remove("pray_type");
            livingEntity.removeEffect(ModEffects.prayer);
        }
        return valid;
    }
}

