/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ovh.corail.tombstone.combine.CombineRecipe;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RenderHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class CombineRecipeCategory
implements IRecipeCategory<CombineRecipe> {
    private static final ResourceLocation COMBINE_RECIPE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/combine_recipe.png");
    private final RecipeType<CombineRecipe> recipeType;
    private final IDrawable background;
    private final IDrawable icon;

    CombineRecipeCategory(RecipeType<CombineRecipe> recipeType, IGuiHelper guiHelper) {
        this.recipeType = recipeType;
        this.background = guiHelper.drawableBuilder(COMBINE_RECIPE, 0, 0, 108, 18).setTextureSize(108, 18).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemAdvancement.IconType.COMBINATION.getItemStack());
    }

    public RecipeType<CombineRecipe> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, CombineRecipe recipe, IFocusGroup focuses) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.combineOn());
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 37, 1).addIngredients(recipe.combined());
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStack(recipe.result().get());
    }

    public void draw(CombineRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (TimeHelper.inIntervalBefore(TimeHelper.systemTime(), 2000, 700)) {
            RenderHelper.Sprites.MOUSE_ON.render(guiGraphics, 17, -2);
        } else {
            RenderHelper.Sprites.MOUSE_OFF.render(guiGraphics, 17, -2);
        }
    }
}

