/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.combine;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.combine.TooltipCombineCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.RenderHelper;

@OnlyIn(value=Dist.CLIENT)
public record ClientTooltipCombineCraft(TooltipCombineCraft tooltip) implements ClientTooltipComponent
{
    private static final int WIDTH = 38;
    private static final int ICON_SIZE = 18;

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (((Boolean)ConfigTombstone.client.showTooltipCombine.get()).booleanValue()) {
            ClientTooltipCombineCraft.render(guiGraphics, x, y, this.tooltip().stack(), this.tooltip().getEnabledCombinations(), true);
        }
    }

    public static void render(GuiGraphics guiGraphics, int x, int y, ItemStack ingredient, List<CombineCraft> combinations, boolean onlyIngredient) {
        int row;
        int left;
        int startX;
        int count = combinations.size();
        if (count == 0) {
            return;
        }
        int slotId = 0;
        int startY = y + 1;
        while (slotId < count) {
            startX = x;
            left = Math.min(5, count - slotId);
            for (row = 0; row < left; ++row) {
                RenderHelper.renderCircle(guiGraphics, startX, startY, -15382113, 18);
                RenderHelper.renderCircle(guiGraphics, startX + 18, startY, -15382113, 18);
                startX += 38;
            }
            slotId += left;
            startY += 19;
        }
        slotId = 0;
        startY = y + 2;
        while (slotId < count) {
            startX = x + 1;
            left = Math.min(5, count - slotId);
            for (row = 0; row < left; ++row) {
                CombineCraft combination = combinations.get(slotId++);
                if (onlyIngredient) {
                    guiGraphics.renderItem(combination.added(), startX, startY);
                    guiGraphics.renderItem(combination.result(), startX + 18, startY);
                } else {
                    guiGraphics.renderItem(ingredient, startX, startY);
                    guiGraphics.renderItem(combination.added(), startX + 18, startY);
                }
                startX += 38;
            }
            startY += 19;
        }
    }

    public int getWidth(Font font) {
        return (Boolean)ConfigTombstone.client.showTooltipCombine.get() != false ? 38 * Math.min(5, this.tooltip().getEnabledCombinations().size()) : 0;
    }

    public int getHeight() {
        return (Boolean)ConfigTombstone.client.showTooltipCombine.get() != false ? 19 * (int)Math.ceil((float)this.tooltip().getEnabledCombinations().size() / 5.0f) + 2 : 0;
    }
}

