/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.combine.CombineUpgrade;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBlockGrave
extends BlockItem {
    public ItemBlockGrave(Block grave) {
        super(grave, new Item.Properties().stacksTo(1).fireResistant().component(ModDataComponents.MODEL_TEXTURE, (Object)0));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(StyleType.TOOLTIP_COMBINE, new Object[0]));
        tooltip.add((Component)Component.translatable((String)"tombstone.block.decorative_grave.desc").setStyle(StyleType.TOOLTIP_DESC));
        String engravedName = EngravableHelper.getEngravedName(stack);
        if (!engravedName.isEmpty()) {
            tooltip.add((Component)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{Component.literal((String)("\"" + engravedName + "\"")).setStyle(StyleType.TOOLTIP_ITEM)}));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public Component getName(ItemStack stack) {
        Component displayName = super.getName(stack);
        return (EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName) : displayName.plainCopy()).withStyle(StyleType.MESSAGE_SPECIAL);
    }

    public boolean overrideOtherStackedOnMe(ItemStack decorativeGrave, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && added.is((Item)ModItems.grave_plate) && decorativeGrave.is((Item)this)) {
            String engravedName = EngravableHelper.getEngravedName(added);
            if (engravedName.isEmpty() || EngravableHelper.isEngraved(decorativeGrave)) {
                ItemStack plateStack = new ItemStack((ItemLike)ModItems.grave_plate);
                ItemStack graveStack = new ItemStack((ItemLike)decorativeGrave.getItem());
                MutableComponent displayName = Component.literal((String)"[").append((Component)(engravedName.isEmpty() ? Component.translatable((String)plateStack.getDescriptionId()) : graveStack.getDisplayName())).append("]").setStyle(StyleType.TOOLTIP_ITEM);
                if (player.level().isClientSide) {
                    ProxyHelper.addToast(EngravableHelper.setEngravedName(plateStack, "named"), graveStack, (Component)(engravedName.isEmpty() ? LangKey.MESSAGE_NOT_ENGRAVED.getText(displayName) : LangKey.MESSAGE_ALREADY_ENGRAVED.getText(displayName)));
                }
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    EngravableHelper.setEngravedName(decorativeGrave, engravedName);
                    added.shrink(1);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COMBINE_IN_INVENTORY));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new TooltipCombineUpgrade(new CombineUpgrade(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "named"), !EngravableHelper.isEngraved(stack))));
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().getBlockState(context.getClickedPos().below()).isRedstoneConductor((BlockGetter)context.getLevel(), context.getClickedPos().below()) && super.placeBlock(context, state);
    }

    public static ItemStack setModelTexture(ItemStack stack, int modelTexture) {
        if (stack.getItem() instanceof ItemBlockGrave) {
            stack.set(ModDataComponents.MODEL_TEXTURE, (Object)Mth.clamp((int)modelTexture, (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1)));
        }
        return stack;
    }

    public static int getModelTexture(ItemStack stack) {
        return Mth.clamp((int)((Integer)stack.getOrDefault(ModDataComponents.MODEL_TEXTURE, (Object)0)), (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    }

    public static ItemStack createDecorativeStack(GraveModel graveModel, int textureId) {
        return ItemBlockGrave.createDecorativeStack(graveModel, textureId, "");
    }

    public static ItemStack createDecorativeStack(GraveModel model, int textureId, String engravedName) {
        ItemStack stack = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)model)), textureId);
        return engravedName.isEmpty() ? stack : EngravableHelper.setEngravedName(stack, engravedName);
    }
}

