/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public final class BlockGraveMarble
extends Block {
    public final String name;

    public BlockGraveMarble(MarbleType type) {
        super(BlockGraveMarble.getBuilder());
        this.name = type.getSerializedName() + "_marble";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LangKey.MESSAGE_CRAFTING_INGREDIENT.getText(StyleType.TOOLTIP_ITEM, new Object[0]));
    }

    public String getDescriptionId() {
        return "tombstone.block." + this.name;
    }

    public static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(4.0f, 1.8E7f).lightLevel(s -> 0).sound(SoundType.STONE);
    }

    public static enum MarbleType implements StringRepresentable
    {
        DARK,
        WHITE,
        BLUE,
        GREEN,
        CARMIN;


        public static MarbleType byId(int id) {
            return id >= 0 && id < MarbleType.values().length ? MarbleType.values()[id] : MarbleType.getDefault();
        }

        public static MarbleType getDefault() {
            return DARK;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

