/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.blockEntity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTriggers;

public final class BlockDecorativeGrave
extends BlockGraveBase
implements EntityBlock {
    public static final MapCodec<BlockDecorativeGrave> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.INT.fieldOf("grave_model").forGetter(a -> a.graveModel.ordinal())).apply((Applicative)c, modelId -> new BlockDecorativeGrave(GraveModel.byId(modelId))));
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.create((String)"is_engraved");
    public static final EnumProperty<SoulType> SOUL_TYPE = EnumProperty.create((String)"soul_type", SoulType.class);

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(false))).setValue(SOUL_TYPE, (Comparable)((Object)SoulType.NONE)));
    }

    protected MapCodec<BlockDecorativeGrave> codec() {
        return CODEC;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        assert (state != null);
        return (BlockState)((BlockState)state.setValue((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(ItemBlockGrave.getModelTexture(context.getItemInHand())))).setValue((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(EngravableHelper.isEngraved(context.getItemInHand())));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IS_ENGRAVED, SOUL_TYPE});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (!EntityHelper.isValidPlayer(playerIn) || hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.FAIL;
        }
        ISoulConsumer soulConsumer = null;
        ItemStack validStack = ItemStack.EMPTY;
        boolean isSoulReceptacle = playerIn.getMainHandItem().is((Item)ModItems.receptacle_of_soul);
        if (isSoulReceptacle) {
            validStack = playerIn.getMainHandItem();
        } else {
            ISoulConsumer offhandSoulConsumer;
            Item item;
            if (!playerIn.getOffhandItem().isEmpty() && (item = playerIn.getOffhandItem().getItem()) instanceof ISoulConsumer && (offhandSoulConsumer = (ISoulConsumer)item).isUsingOffhandToEnchant()) {
                soulConsumer = offhandSoulConsumer;
                validStack = playerIn.getOffhandItem();
            }
            if (validStack.isEmpty() && !playerIn.getMainHandItem().isEmpty() && (item = playerIn.getMainHandItem().getItem()) instanceof ISoulConsumer) {
                ISoulConsumer mainhandSoulConsumer = (ISoulConsumer)item;
                if (mainhandSoulConsumer.isUsingOffhandToEnchant()) {
                    if (!playerIn.level().isClientSide()) {
                        LangKey.MESSAGE_ENCHANT_WITH_OFFHAND.sendMessage(playerIn, new Object[0]);
                    }
                    return ItemInteractionResult.FAIL;
                }
                soulConsumer = mainhandSoulConsumer;
                validStack = playerIn.getMainHandItem();
            }
        }
        if (validStack.isEmpty()) {
            return ItemInteractionResult.FAIL;
        }
        if (playerIn.level().isClientSide()) {
            return EntityHelper.noGlobalItemCooldown(playerIn, validStack) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        if (!isSoulReceptacle && soulConsumer == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (EntityHelper.noGlobalItemCooldown((Player)serverPlayer, validStack)) {
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, validStack, 10);
                if (((SoulType)((Object)state.getValue(SOUL_TYPE))).hasSoul()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendMessage((Player)serverPlayer, new Object[0]);
                    return ItemInteractionResult.FAIL;
                }
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                if (bolt != null) {
                    bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    bolt.setVisualOnly(true);
                    level.addFreshEntity((Entity)bolt);
                }
                level.setBlock(pos, (BlockState)state.setValue(SOUL_TYPE, (Comparable)((Object)SoulType.WEAK)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendSpecialMessage((Player)serverPlayer, new Object[0]);
                if (!serverPlayer.isCreative()) {
                    serverPlayer.getMainHandItem().shrink(1);
                }
                PlayerKnowledgeHandler.rewardKnowledge(serverPlayer, 10);
                PlayerAlignmentHandler.rewardAlignment(serverPlayer, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get());
                ModTriggers.free_soul.trigger(serverPlayer);
                return ItemInteractionResult.SUCCESS;
            }
            if (soulConsumer.isEnchanted(validStack)) {
                LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage((Player)serverPlayer, new Object[0]);
            } else {
                SoulType soulType = (SoulType)((Object)state.getValue(SOUL_TYPE));
                if (soulType.hasSoul()) {
                    int soulStrength = soulType.getSoulStrength();
                    if (soulConsumer.canEnchant(level, pos, (Player)serverPlayer, validStack)) {
                        ISoulConsumer.ConsumeResult consumeResult = soulConsumer.setEnchant(level, pos, serverPlayer, validStack, soulStrength);
                        if (consumeResult.result().success()) {
                            if (soulStrength == 2) {
                                if (consumeResult.soulStrength() == 1) {
                                    ModTriggers.knowledge_wasted.trigger(serverPlayer);
                                } else if (consumeResult.soulStrength() > 1) {
                                    ModTriggers.create_ancient_item.trigger(serverPlayer);
                                }
                            }
                            level.setBlock(pos, (BlockState)state.setValue(SOUL_TYPE, (Comparable)((Object)soulType.consume(consumeResult.soulStrength()))), 3);
                            Helper.getDecorativeGrave(level, pos).ifPresent(BlockEntityDecorativeGrave::resetCheckSoul);
                            ModSounds.playSoundAllAround(ModSounds.magic_use01, SoundSource.PLAYERS, level, serverPlayer.blockPosition(), 0.5f, 0.5f);
                            LangKey.sendSystemMessage((Player)serverPlayer, consumeResult.message(), StyleType.MESSAGE_SPECIAL);
                            ModTriggers.consume_soul.trigger(serverPlayer);
                            PlayerKnowledgeHandler.rewardKnowledge(serverPlayer, soulConsumer.getKnowledge());
                        } else {
                            LangKey.sendSystemMessage((Player)serverPlayer, consumeResult.message(), StyleType.COLOR_OFF);
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage((Player)serverPlayer, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage((Player)serverPlayer, new Object[0]);
                }
            }
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, validStack, 10);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Item item;
        ItemStack stack;
        if (entity.isShiftKeyDown() && entity.isAlive() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((Player)entity).getMainHandItem()).isEmpty() && (item = stack.getItem()) instanceof ISoulConsumer) {
            ISoulConsumer soulConsumer = (ISoulConsumer)item;
            soulConsumer.onSneakGrave(level, pos, (Player)entity, stack);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        String engraved_name;
        if (!level.isClientSide() && !(engraved_name = EngravableHelper.getEngravedName(stack)).isEmpty()) {
            Helper.getDecorativeGrave(level, pos).ifPresent(tile -> tile.setOwner(Optional.ofNullable(placer).filter(Player.class::isInstance).map(Player.class::cast).map(p -> p.getGameProfile().getId()).orElse(null), engraved_name, TimeHelper.systemTime()));
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player) ? super.getDestroyProgress(state, player, blockGetter, pos) : 0.0f;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest && Helper.getDecorativeGrave(level, pos).map(g -> g.isOwner(player)).orElse(false).booleanValue()) {
            level.levelEvent(player, 2001, pos, BlockDecorativeGrave.getId((BlockState)state));
            if (!level.isClientSide()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    protected void onDrop(Level level, BlockPos pos, BlockState oldState) {
        Helper.getDecorativeGrave(level, pos).ifPresent(grave -> Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)ItemBlockGrave.createDecorativeStack(this.graveModel, (Integer)oldState.getValue((Property)MODEL_TEXTURE), grave.getOwnerName())));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDecorativeGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockDecorativeGrave.createTickerHelper(entityType, ModBlocks.tile_decorative_grave, level.isClientSide() ? BlockEntityDecorativeGrave::clientTick : BlockEntityDecorativeGrave::serverTick);
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(20.0f, 1.8E7f).sound(SoundType.STONE);
    }
}

