/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.models;

import ca.fxco.moreculling.api.data.QuadBounds;
import ca.fxco.moreculling.api.model.BakedOpacity;
import ca.fxco.moreculling.api.sprite.SpriteOpacity;
import ca.fxco.moreculling.utils.DirectionBits;
import ca.fxco.moreculling.utils.VertexUtils;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SimpleBakedModel.class})
public abstract class SimpleBakedModel_cacheMixin
implements BakedOpacity {
    @Shadow
    @Final
    protected Map<Direction, List<BakedQuad>> culledFaces;
    @Unique
    private final DirectionBits moreculling$solidFaces = new DirectionBits();
    @Unique
    private boolean moreculling$allStatesCanOcclude = true;
    @Unique
    @Nullable
    private VoxelShape moreculling$cullVoxelShape;
    @Unique
    private boolean moreculling$wasShapeOptimized = false;

    @Override
    public boolean moreculling$hasTextureTranslucency(@Nullable BlockState state, @Nullable Direction direction) {
        return direction == null ? this.moreculling$solidFaces.notFull() : !this.moreculling$solidFaces.contains(direction);
    }

    @Override
    public void moreculling$resetTranslucencyCache(BlockState state) {
        this.moreculling$solidFaces.clear();
        if (state.canOcclude()) {
            if (this.moreculling$allStatesCanOcclude) {
                this.moreculling$solidFaces.fill();
            }
        } else {
            this.moreculling$allStatesCanOcclude = false;
        }
        for (Map.Entry<Direction, List<BakedQuad>> entry : this.culledFaces.entrySet()) {
            NativeImage image;
            QuadBounds bounds;
            BakedQuad initialQuad;
            SpriteOpacity opacity;
            Direction direction = entry.getKey();
            ArrayList layeredQuads = new ArrayList(entry.getValue());
            if (layeredQuads.isEmpty() || (opacity = (SpriteOpacity)(initialQuad = (BakedQuad)layeredQuads.removeFirst()).getSprite()).moreculling$hasTranslucency(bounds = VertexUtils.getQuadUvBounds(initialQuad, (image = opacity.moreculling$getUnmipmappedImage()).getWidth(), image.getHeight()))) continue;
            if (!layeredQuads.isEmpty()) {
                ArrayList<NativeImage> overlappingImages = new ArrayList<NativeImage>();
                for (BakedQuad quad : layeredQuads) {
                    overlappingImages.add(((SpriteOpacity)quad.getSprite()).moreculling$getUnmipmappedImage());
                }
                if (opacity.moreculling$hasTranslucency(bounds, overlappingImages)) continue;
                this.moreculling$solidFaces.add(direction);
                continue;
            }
            this.moreculling$solidFaces.add(direction);
        }
    }

    @Override
    @Nullable
    public VoxelShape moreculling$getCullingShape(BlockState state) {
        if (!this.moreculling$wasShapeOptimized) {
            if (this.moreculling$cullVoxelShape != null) {
                this.moreculling$cullVoxelShape = this.moreculling$cullVoxelShape.optimize();
            }
            this.moreculling$wasShapeOptimized = true;
        }
        return this.moreculling$cullVoxelShape;
    }

    @Override
    public void moreculling$setCullingShape(VoxelShape cullingShape) {
        this.moreculling$cullVoxelShape = cullingShape;
    }

    @Override
    public boolean moreculling$canSetCullingShape() {
        return true;
    }
}

