/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.config.cloth.AbstractDynamicBuilder;
import ca.fxco.moreculling.config.cloth.DynamicIntSliderEntry;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DynamicIntSliderBuilder
extends AbstractDynamicBuilder<Integer, DynamicIntSliderEntry, DynamicIntSliderBuilder> {
    private int max;
    private int min;
    private Function<Integer, Component> textGetter = null;

    public DynamicIntSliderBuilder(String translationKey, int min, int max) {
        super(translationKey);
        this.max = max;
        this.min = min;
    }

    public DynamicIntSliderBuilder(String translationKey, Component resetButtonKey, int min, int max) {
        super(translationKey, resetButtonKey);
        this.max = max;
        this.min = min;
    }

    public DynamicIntSliderBuilder setTextGetter(Function<Integer, Component> textGetter) {
        this.textGetter = textGetter;
        return this;
    }

    public DynamicIntSliderBuilder setMax(int max) {
        this.max = max;
        return this;
    }

    public DynamicIntSliderBuilder setMin(int min) {
        this.min = min;
        return this;
    }

    @Override
    @NotNull
    public DynamicIntSliderEntry runBuild() {
        DynamicIntSliderEntry entry = new DynamicIntSliderEntry(this, this.min, this.max);
        if (this.textGetter != null) {
            entry.setTextGetter(this.textGetter);
        }
        entry.setTooltipSupplier(() -> (Optional)this.tooltipSupplier.apply((Integer)entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply((Integer)entry.getValue()));
        }
        return entry;
    }
}

