/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.handler;

import com.blakebr0.ironjetpacks.client.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.network.payloads.DecrementThrottlePayload;
import com.blakebr0.ironjetpacks.network.payloads.IncrementThrottlePayload;
import com.blakebr0.ironjetpacks.network.payloads.ToggleEnginePayload;
import com.blakebr0.ironjetpacks.network.payloads.ToggleHUDPayload;
import com.blakebr0.ironjetpacks.network.payloads.ToggleHoverPayload;
import com.blakebr0.ironjetpacks.network.payloads.UpdateInputPayload;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class KeybindHandler {
    private static KeyMapping keyEngine;
    private static KeyMapping keyHover;
    private static KeyMapping keyHUD;
    private static KeyMapping keyAscend;
    private static KeyMapping keyDescend;
    private static KeyMapping keyIncrementThrottle;
    private static KeyMapping keyDecrementThrottle;
    private static boolean up;
    private static boolean down;
    private static boolean forwards;
    private static boolean backwards;
    private static boolean left;
    private static boolean right;
    private static boolean sprint;

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        keyEngine = new KeyMapping("keybind.ironjetpacks.engine", 86, "Iron Jetpacks");
        keyHover = new KeyMapping("keybind.ironjetpacks.hover", 72, "Iron Jetpacks");
        keyHUD = new KeyMapping("keybind.ironjetpacks.hud", InputConstants.UNKNOWN.getValue(), "Iron Jetpacks");
        keyAscend = new KeyMapping("keybind.ironjetpacks.ascend", InputConstants.UNKNOWN.getValue(), "Iron Jetpacks");
        keyDescend = new KeyMapping("keybind.ironjetpacks.descend", InputConstants.UNKNOWN.getValue(), "Iron Jetpacks");
        keyIncrementThrottle = new KeyMapping("keybind.ironjetpacks.increment_throttle", 46, "Iron Jetpacks");
        keyDecrementThrottle = new KeyMapping("keybind.ironjetpacks.decrement_throttle", 44, "Iron Jetpacks");
        event.register(keyEngine);
        event.register(keyHover);
        event.register(keyHUD);
        event.register(keyAscend);
        event.register(keyDescend);
        event.register(keyIncrementThrottle);
        event.register(keyDecrementThrottle);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack chest = JetpackUtils.getEquippedJetpack((Player)player);
        Item item = chest.getItem();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((Player)player, chest);
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack chest = JetpackUtils.getEquippedJetpack((Player)player);
        Item item = chest.getItem();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((Player)player, chest);
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        Options settings = mc.options;
        if (mc.getConnection() == null) {
            return;
        }
        boolean upNow = keyAscend.isUnbound() ? settings.keyJump.isDown() : keyAscend.isDown();
        boolean downNow = keyDescend.isUnbound() ? settings.keyShift.isDown() : keyDescend.isDown();
        boolean forwardsNow = settings.keyUp.isDown();
        boolean backwardsNow = settings.keyDown.isDown();
        boolean leftNow = settings.keyLeft.isDown();
        boolean rightNow = settings.keyRight.isDown();
        boolean sprintNow = settings.keySprint.isDown();
        if (upNow != up || downNow != down || forwardsNow != forwards || backwardsNow != backwards || leftNow != left || rightNow != right || sprintNow != sprint) {
            up = upNow;
            down = downNow;
            forwards = forwardsNow;
            backwards = backwardsNow;
            left = leftNow;
            right = rightNow;
            sprint = sprintNow;
            KeybindHandler.update(up, down, forwards, backwards, left, right, sprint);
        }
    }

    public static void update(boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right, boolean sprint) {
        LocalPlayer player = Minecraft.getInstance().player;
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateInputPayload(up, down, forwards, backwards, left, right, sprint), (CustomPacketPayload[])new CustomPacketPayload[0]);
        InputHandler.update((Player)player, up, down, forwards, backwards, left, right, sprint);
    }

    private static void handleInput(Player player, ItemStack stack) {
        MutableComponent throttleText;
        MutableComponent state;
        boolean on;
        if (keyEngine.consumeClick()) {
            on = JetpackUtils.toggleEngine(stack);
            state = on ? ModTooltips.ON.color(ChatFormatting.GREEN).build() : ModTooltips.OFF.color(ChatFormatting.RED).build();
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleEnginePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)ModTooltips.TOGGLE_ENGINE.args(new Object[]{state}).build(), true);
        }
        if (keyHover.consumeClick()) {
            on = JetpackUtils.toggleHover(stack);
            state = on ? ModTooltips.ON.color(ChatFormatting.GREEN).build() : ModTooltips.OFF.color(ChatFormatting.RED).build();
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleHoverPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)ModTooltips.TOGGLE_HOVER.args(new Object[]{state}).build(), true);
        }
        if (keyHUD.consumeClick()) {
            on = JetpackUtils.toggleHUD(stack);
            state = on ? ModTooltips.ON.color(ChatFormatting.GREEN).build() : ModTooltips.OFF.color(ChatFormatting.RED).build();
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleHUDPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)ModTooltips.TOGGLE_HUD.args(new Object[]{state}).build(), true);
        }
        if (keyIncrementThrottle.consumeClick()) {
            double throttle = JetpackUtils.incrementThrottle(stack);
            throttleText = Component.literal((String)((int)(throttle * 100.0) + "%")).withStyle(ChatFormatting.GREEN);
            PacketDistributor.sendToServer((CustomPacketPayload)new IncrementThrottlePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
        if (keyDecrementThrottle.consumeClick()) {
            double throttle = JetpackUtils.decrementThrottle(stack);
            throttleText = Component.literal((String)((int)(throttle * 100.0) + "%")).withStyle(ChatFormatting.RED);
            PacketDistributor.sendToServer((CustomPacketPayload)new DecrementThrottlePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
    }

    static {
        up = false;
        down = false;
        forwards = false;
        backwards = false;
        left = false;
        right = false;
        sprint = false;
    }
}

