/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.document.SpatialQuery;
import guideme.internal.shaded.lucene.geo.Component2D;
import guideme.internal.shaded.lucene.geo.GeoEncodingUtils;
import guideme.internal.shaded.lucene.geo.Geometry;
import guideme.internal.shaded.lucene.geo.LatLonGeometry;
import guideme.internal.shaded.lucene.geo.Line;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.util.NumericUtils;
import java.util.function.Function;
import java.util.function.Predicate;

final class LatLonShapeQuery
extends SpatialQuery {
    LatLonShapeQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        super(field, queryRelation, LatLonShapeQuery.validateGeometries(queryRelation, geometries));
    }

    private static LatLonGeometry[] validateGeometries(ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        if (geometries != null && queryRelation == ShapeField.QueryRelation.WITHIN) {
            for (LatLonGeometry geometry : geometries) {
                if (!(geometry instanceof Line)) continue;
                throw new IllegalArgumentException("LatLonShapeQuery does not support " + String.valueOf((Object)ShapeField.QueryRelation.WITHIN) + " queries with line geometries");
            }
        }
        return geometries;
    }

    @Override
    protected Component2D createComponent2D(Geometry ... geometries) {
        return LatLonGeometry.create((LatLonGeometry[])geometries);
    }

    static SpatialQuery.SpatialVisitor getSpatialVisitor(final Component2D component2D) {
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minTriangle, byte[] maxTriangle) {
                double minLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(minTriangle, 0));
                double minLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(minTriangle, 4));
                double maxLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(maxTriangle, 8));
                double maxLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(maxTriangle, 12));
                return component2D.relate(minLon, maxLon, minLat, maxLat);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return component2D.contains(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return component2D.intersectsLine(alon, alat, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return component2D.intersectsTriangle(alon, alat, blon, blat, clon, clat);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + String.valueOf((Object)scratchTriangle.type) + "]");
                };
            }

            @Override
            protected Predicate<byte[]> within() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return component2D.contains(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return component2D.containsLine(alon, alat, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return component2D.containsTriangle(alon, alat, blon, blat, clon, clat);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + String.valueOf((Object)scratchTriangle.type) + "]");
                };
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return component2D.withinPoint(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return component2D.withinLine(alon, alat, scratchTriangle.ab, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return component2D.withinTriangle(alon, alat, scratchTriangle.ab, blon, blat, scratchTriangle.bc, clon, clat, scratchTriangle.ca);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + String.valueOf((Object)scratchTriangle.type) + "]");
                };
            }
        };
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        return LatLonShapeQuery.getSpatialVisitor(this.queryComponent2D);
    }
}

