/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytNode;
import guideme.document.block.LytVisitor;
import guideme.document.flow.LytFlowContainer;
import guideme.document.flow.LytFlowContent;
import guideme.layout.LayoutContext;
import guideme.layout.flow.FlowBuilder;
import guideme.layout.flow.LineBlock;
import guideme.layout.flow.LineElement;
import guideme.render.RenderContext;
import guideme.style.ResolvedTextStyle;
import java.util.stream.Stream;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;

public class LytParagraph
extends LytBlock
implements LytFlowContainer {
    protected final FlowBuilder content = new FlowBuilder();
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;
    @Nullable
    protected LytFlowContent hoveredContent;

    @Override
    public void append(LytFlowContent child) {
        this.content.append(child);
        child.setParent(this);
    }

    @Override
    public boolean isCulled(LytRect viewport) {
        if (this.content.floatsIntersect(viewport)) {
            return false;
        }
        return super.isCulled(viewport);
    }

    @Override
    public LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        ResolvedTextStyle style = this.resolveStyle();
        LytRect bounds = this.content.computeLayout(context, x += this.paddingLeft, y += this.paddingTop, availableWidth -= this.paddingLeft + this.paddingRight, style.alignment());
        if (this.paddingBottom != 0) {
            return bounds.withHeight(bounds.height() + this.paddingBottom);
        }
        return bounds;
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        this.content.move(deltaX, deltaY);
    }

    @Override
    public void onMouseEnter(@Nullable LytFlowContent hoveredContent) {
        super.onMouseEnter(hoveredContent);
        this.hoveredContent = hoveredContent;
    }

    @Override
    public void onMouseLeave() {
        super.onMouseLeave();
        this.hoveredContent = null;
    }

    @Override
    @Nullable
    public LytNode pickNode(int x, int y) {
        LineBlock fl = this.content.pickFloatingElement(x, y);
        if (fl != null) {
            return this;
        }
        return super.pickNode(x, y);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        if (context.intersectsViewport(this.bounds)) {
            this.content.renderBatch(context, buffers, this.hoveredContent);
        }
        this.content.renderFloatsBatch(context, buffers, this.hoveredContent);
    }

    @Override
    public void render(RenderContext context) {
        if (context.intersectsViewport(this.bounds)) {
            this.content.render(context, this.hoveredContent);
        }
        this.content.renderFloats(context, this.hoveredContent);
    }

    @Override
    @Nullable
    public LytFlowContent pickContent(int x, int y) {
        LineElement lineEl = this.content.pick(x, y);
        return lineEl != null ? lineEl.getFlowContent() : null;
    }

    @Override
    public Stream<LytRect> enumerateContentBounds(LytFlowContent content) {
        return this.content.enumerateContentBounds(content);
    }

    @Override
    protected LytVisitor.Result visitChildren(LytVisitor visitor, boolean includeOutOfTreeContent) {
        if (super.visitChildren(visitor, includeOutOfTreeContent) == LytVisitor.Result.STOP) {
            return LytVisitor.Result.STOP;
        }
        for (LytFlowContent flowContent : this.getContent()) {
            flowContent.visit(visitor);
        }
        return LytVisitor.Result.CONTINUE;
    }

    public Iterable<LytFlowContent> getContent() {
        return this.content.getContent();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void clearContent() {
        this.content.clear();
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }
}

