/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.neoforge.common.packs;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.DoApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class BuiltInPackRegistry {
    public static final Map<ResourceLocation, Pair<PackResources, Boolean>> packResources = new HashMap<ResourceLocation, Pair<PackResources, Boolean>>();

    public static void getPacks(Consumer<Pack> consumer, boolean client) {
        if (packResources.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceLocation, Pair<PackResources, Boolean>> entry : packResources.entrySet()) {
            Pair<PackResources, Boolean> pair = entry.getValue();
            PackResources packResources = (PackResources)pair.getFirst();
            ResourceLocation id = entry.getKey();
            Boolean alwaysEnabled = (Boolean)pair.getSecond();
            if (packResources == null) {
                DoApi.LOGGER.error("Pack for location: {} is null, skipping it!", (Object)id);
                continue;
            }
            if (client && packResources.getNamespaces(PackType.CLIENT_RESOURCES).isEmpty()) {
                DoApi.LOGGER.debug(packResources.packId() + " has no assets, skipping it!");
                continue;
            }
            if (!client && packResources.getNamespaces(PackType.SERVER_DATA).isEmpty()) {
                DoApi.LOGGER.debug(packResources.packId() + " has no data, skipping it!");
                continue;
            }
            IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(id.getNamespace()).orElseThrow(() -> new IllegalArgumentException("Mod not found: " + id.getNamespace()))).getModInfo();
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("mod/" + String.valueOf(packResources.location()), (Component)Component.literal((String)(id.getNamespace() + "/" + id.getPath())), PackSource.BUILT_IN, Optional.of(new KnownPack(id.getNamespace(), "mod/" + String.valueOf(packResources.location()), modInfo.getVersion().toString()))), (Pack.ResourcesSupplier)BuiltInPackSource.fromName(path -> new PathPackResources(path, modInfo.getOwningFile().getFile().findResource(new String[]{id.getPath()}))), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(alwaysEnabled.booleanValue(), Pack.Position.TOP, false));
            if (pack != null) {
                consumer.accept(pack);
                continue;
            }
            DoApi.LOGGER.error(packResources.packId() + " couldn't be created");
        }
    }
}

