/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.util;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralUtil {
    private static final String BLOCK_POS_KEY = "block_pos";
    private static final String BLOCK_POSES_KEY = "block_poses";
    public static final EnumProperty<LineConnectingType> LINE_CONNECTING_TYPE = EnumProperty.create((String)"type", LineConnectingType.class);

    public static boolean isFullAndSolid(LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFaceFull(levelReader, blockPos) && GeneralUtil.isSolid(levelReader, blockPos);
    }

    public static boolean isFaceFull(LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.below();
        return Block.isFaceFull((VoxelShape)levelReader.getBlockState(belowPos).getShape((BlockGetter)levelReader, belowPos), (Direction)Direction.UP);
    }

    public static boolean isSolid(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos.below()).isSolid();
    }

    public static boolean matchesRecipe(RecipeInput inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stackInSlot = inventory.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            validStacks.add(stackInSlot);
        }
        for (Ingredient entry : recipe) {
            boolean matches = false;
            for (ItemStack item : validStacks) {
                if (!entry.test(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.joinUnoptimized((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.OR);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public static void spawnSlice(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.setDeltaMovement(xMotion, yMotion, zMotion);
        level.addFreshEntity((Entity)entity);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.getChunkSource().chunkMap.getPlayers(pos, false);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static float getInPercent(int i) {
        return (float)i / 100.0f;
    }

    public static ItemStack convertStackAfterFinishUsing(LivingEntity entity, ItemStack used, Item returnItem, Item usedItem) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, used);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)usedItem));
        }
        if (used.isEmpty()) {
            return new ItemStack((ItemLike)returnItem);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Player)entity).getAbilities().instabuild) {
                ItemStack itemStack2 = new ItemStack((ItemLike)returnItem);
                if (!player.getInventory().add(itemStack2)) {
                    player.drop(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static InteractionResult fillBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.isClientSide) {
            Item item = itemStack.getItem();
            player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            level.setBlockAndUpdate(blockPos, blockState);
            level.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockPos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static InteractionResult emptyBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.isClientSide) {
            Item item = itemStack.getItem();
            player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            level.setBlockAndUpdate(blockPos, blockState);
            level.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static RotatedPillarBlock logBlock() {
        return new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG));
    }

    public static boolean isDamageType(DamageSource source, List<ResourceKey<DamageType>> damageTypes) {
        for (ResourceKey<DamageType> key : damageTypes) {
            if (!source.is(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFire(DamageSource source) {
        return GeneralUtil.isDamageType(source, List.of(DamageTypes.ON_FIRE, DamageTypes.IN_FIRE, DamageTypes.FIREBALL, DamageTypes.FIREWORKS, DamageTypes.UNATTRIBUTED_FIREBALL));
    }

    public static boolean isIndexInRange(int index, int startInclusive, int endInclusive) {
        return index >= startInclusive && index <= endInclusive;
    }

    public static FriendlyByteBuf create() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void popResourceFromFace(Level level, BlockPos blockPos, Direction side, ItemStack itemStack) {
        BlockState blockState = level.getBlockState(blockPos);
        double itemWidth = EntityType.ITEM.getWidth();
        double itemHeight = EntityType.ITEM.getHeight();
        VoxelShape shape = blockState.getCollisionShape((BlockGetter)level, blockPos);
        double posX = (double)blockPos.getX() + 0.5;
        double posY = (double)blockPos.getY() + 0.5;
        double posZ = (double)blockPos.getZ() + 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        switch (side) {
            case DOWN: {
                posY = (double)blockPos.getY() - shape.min(Direction.Axis.Y);
                offsetY = -itemHeight * 2.0;
                break;
            }
            case UP: {
                posY = (double)blockPos.getY() + shape.max(Direction.Axis.Y);
                break;
            }
            case NORTH: {
                posZ = (double)blockPos.getZ() + shape.min(Direction.Axis.Z);
                offsetZ = -itemWidth;
                break;
            }
            case SOUTH: {
                posZ = (double)blockPos.getZ() + shape.max(Direction.Axis.Z);
                offsetZ = itemWidth;
                break;
            }
            case WEST: {
                posX = (double)blockPos.getX() + shape.min(Direction.Axis.X);
                offsetX = -itemWidth;
                break;
            }
            case EAST: {
                posX = (double)blockPos.getX() + shape.max(Direction.Axis.X);
                offsetX = itemWidth;
            }
        }
        int i = side.getStepX();
        int j = side.getStepY();
        int k = side.getStepZ();
        double deltaX = i == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1) : (double)i * 0.1;
        double deltaY = j == 0 ? Mth.nextDouble((RandomSource)level.random, (double)0.0, (double)0.1) : (double)j * 0.1 + 0.1;
        double deltaZ = k == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1) : (double)k * 0.1;
        GeneralUtil.popResource(level, new ItemEntity(level, posX + offsetX, posY + offsetY, posZ + offsetZ, itemStack, deltaX, deltaY, deltaZ), itemStack);
    }

    private static void popResource(Level level, ItemEntity itemEntity, ItemStack itemStack) {
        if (!level.isClientSide && !itemStack.isEmpty() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void putBlockPos(CompoundTag compoundTag, BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        int[] positions = new int[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()};
        compoundTag.putIntArray(BLOCK_POS_KEY, positions);
    }

    public static void putBlockPoses(CompoundTag compoundTag, Collection<BlockPos> blockPoses) {
        if (blockPoses == null || blockPoses.isEmpty()) {
            return;
        }
        int[] positions = new int[blockPoses.size() * 3];
        int pos = 0;
        for (BlockPos blockPos : blockPoses) {
            positions[pos * 3] = blockPos.getX();
            positions[pos * 3 + 1] = blockPos.getY();
            positions[pos * 3 + 2] = blockPos.getZ();
            ++pos;
        }
        compoundTag.putIntArray(BLOCK_POSES_KEY, positions);
    }

    @Nullable
    public static BlockPos readBlockPos(CompoundTag compoundTag) {
        if (!compoundTag.contains(BLOCK_POS_KEY)) {
            return null;
        }
        int[] positions = compoundTag.getIntArray(BLOCK_POS_KEY);
        return new BlockPos(positions[0], positions[1], positions[2]);
    }

    public static Set<BlockPos> readBlockPoses(CompoundTag compoundTag) {
        HashSet<BlockPos> blockSet = new HashSet<BlockPos>();
        if (!compoundTag.contains(BLOCK_POSES_KEY)) {
            return blockSet;
        }
        int[] positions = compoundTag.getIntArray(BLOCK_POSES_KEY);
        for (int pos = 0; pos < positions.length / 3; ++pos) {
            blockSet.add(new BlockPos(positions[pos * 3], positions[pos * 3 + 1], positions[pos * 3 + 2]));
        }
        return blockSet;
    }

    public static enum LineConnectingType implements StringRepresentable
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

