/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.util;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.entity.ChairEntity;
import de.cristelknight.doapi.common.registry.DoApiEntityTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ChairUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>> CHAIRS = new HashMap<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>>();

    public static InteractionResult onUse(Level world, Player player, InteractionHand hand, BlockHitResult hit, double extraHeight) {
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (ChairUtil.isPlayerSitting(player)) {
            return InteractionResult.PASS;
        }
        if (hit.getDirection() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hit.getBlockPos();
        if (!ChairUtil.isOccupied(world, hitPos) && player.getItemInHand(hand).isEmpty()) {
            ChairEntity chair = (ChairEntity)((EntityType)DoApiEntityTypes.CHAIR.get()).create(world);
            chair.moveTo((double)hitPos.getX() + 0.5, (double)hitPos.getY() + 0.25 + extraHeight, (double)hitPos.getZ() + 0.5, 0.0f, 0.0f);
            if (ChairUtil.addChairEntity(world, hitPos, chair, player.blockPosition())) {
                world.addFreshEntity((Entity)chair);
                player.startRiding((Entity)chair);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void onStateReplaced(Level world, BlockPos pos) {
        ChairEntity entity;
        if (!world.isClientSide && (entity = ChairUtil.getChairEntity(world, pos)) != null) {
            ChairUtil.removeChairEntity(world, pos);
            entity.ejectPassengers();
        }
    }

    public static boolean addChairEntity(Level world, BlockPos blockPos, ChairEntity entity, BlockPos playerPos) {
        if (!world.isClientSide) {
            ResourceLocation id = ChairUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.isClientSide && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static ChairEntity getChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.isClientSide() && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, ChairEntity chairEntity) {
        ResourceLocation id;
        if (!player.level().isClientSide() && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(player.level()))) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (BlockPos)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = ChairUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).hasPassenger((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.dimension().location();
    }
}

