/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import de.cristelknight.doapi.DoApiEP;
import de.cristelknight.doapi.common.recipe.codec.ConditionalCodecs;
import de.cristelknight.doapi.common.recipe.codec.Conditionals;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ConditionalRecipe {
    public static final String DEFAULT_FIELD = "doapi:conditional";
    private static final MapCodec<Recipe<?>> CODEC = new MapCodec<Recipe<?>>(){

        public <T> RecordBuilder<T> encode(Recipe<?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            if (!(input instanceof Wrapper)) {
                throw new IllegalArgumentException("ConditionalRecipe.CODEC can only encode ConditionalRecipe.Wrapper instances");
            }
            Wrapper wrapper = (Wrapper)input;
            prefix.add(ConditionalRecipe.DEFAULT_FIELD, ConditionalCodecs.CONDITIONALS_CODEC.encodeStart(ops, (Object)wrapper.conditions));
            prefix.add(ConditionalRecipe.DEFAULT_FIELD, Recipe.CODEC.encodeStart(ops, wrapper.recipe));
            return prefix;
        }

        public <T> DataResult<Recipe<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object recipeElement = input.get("recipe");
            if (recipeElement == null) {
                return DataResult.error(() -> "Missing `recipe` entry");
            }
            DataResult recipe = Recipe.CODEC.parse(ops, recipeElement);
            if (recipe.error().isPresent()) {
                return DataResult.error(() -> "Failed to parse `recipe` entry: " + ((DataResult.Error)recipe.error().get()).message());
            }
            return recipe;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString(ConditionalRecipe.DEFAULT_FIELD), ops.createString("recipe"));
        }

        private <T> DataResult<Recipe<?>> accept(DynamicOps<T> ops, Holder<Integer> count, T entry) {
            DataResult parsed;
            count.value = (Integer)count.value + 1;
            MapLike map = ops.getMap(entry).result().orElse(null);
            if (map == null) {
                return DataResult.error(() -> "Entry " + String.valueOf(count.value) + " was not MapLike " + String.valueOf(entry.getClass()));
            }
            if (map.get(ConditionalRecipe.DEFAULT_FIELD) != null && !(parsed = ConditionalCodecs.CONDITIONALS_CODEC.parse(ops, map.get(ConditionalRecipe.DEFAULT_FIELD))).result().isPresent()) {
                return DataResult.error(() -> "Failed to parse condition " + String.valueOf(count.value));
            }
            Object recipe = map.get("recipe");
            if (recipe == null) {
                return DataResult.error(() -> "Missing `recipe` entry " + String.valueOf(count.value));
            }
            return Recipe.CODEC.parse(ops, recipe);
        }
    }.stable();
    public static final RecipeSerializer<Recipe<?>> SERIALIZER = new RecipeSerializer<Recipe<?>>(){

        @NotNull
        public MapCodec<Recipe<?>> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, Recipe<?>> streamCodec() {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support encoding to network");
        }
    };

    public static boolean checkCondition(JsonObject c) {
        String type = GsonHelper.getAsString((JsonObject)c, (String)"type");
        if (type.equals("forge:mod_loaded")) {
            String modId = c.get("modid").getAsString();
            return DoApiEP.isModLoaded(modId);
        }
        return false;
    }

    private static final class Holder<T> {
        private T value;

        private Holder() {
        }
    }

    private static class Wrapper
    implements Recipe<CraftingInput> {
        private final Conditionals conditions;
        private final Recipe<?> recipe;

        public boolean matches(CraftingInput inv, Level level) {
            return false;
        }

        public ItemStack assemble(CraftingInput inv, HolderLookup.Provider reg) {
            return null;
        }

        public boolean canCraftInDimensions(int width, int height) {
            return false;
        }

        public ItemStack getResultItem(HolderLookup.Provider reg) {
            return null;
        }

        public RecipeSerializer<?> getSerializer() {
            return SERIALIZER;
        }

        public RecipeType<?> getType() {
            throw new UnsupportedOperationException();
        }

        private Wrapper(Conditionals main, Recipe<?> recipes) {
            this.conditions = main;
            this.recipe = recipes;
        }
    }
}

