/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.storage;

import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.registry.DoApiStorageTypeRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FlowerBoxBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.5625, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5625, (double)0.0625, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    public FlowerBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public ResourceLocation type() {
        return DoApiStorageTypeRegistry.FLOWER_BOX;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.is(ItemTags.SMALL_FLOWERS);
    }

    @Override
    public int getSection(Float x, Float y) {
        if ((double)x.floatValue() < 0.5) {
            return 0;
        }
        return 1;
    }

    @Override
    public SoundEvent getAddSound(Level level, BlockPos blockPos, Player player, int i) {
        return SoundEvents.GRASS_PLACE;
    }

    @Override
    public SoundEvent getRemoveSound(Level level, BlockPos blockPos, Player player, int i) {
        return SoundEvents.GRASS_BREAK;
    }
}

