/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StorageBlockEntity
extends BlockEntity {
    private int size;
    private NonNullList<ItemStack> inventory;

    public StorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DoApiBlockEntityTypes.STORAGE_ENTITY.get(), pos, state);
    }

    public StorageBlockEntity(BlockPos pos, BlockState state, int size) {
        super((BlockEntityType)DoApiBlockEntityTypes.STORAGE_ENTITY.get(), pos, state);
        this.size = size;
        this.inventory = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
    }

    public void setStack(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
            this.setChanged();
        }
    }

    public ItemStack removeStack(int slot) {
        if (slot >= 0 && slot < this.inventory.size()) {
            ItemStack stack = (ItemStack)this.inventory.set(slot, (Object)ItemStack.EMPTY);
            this.setChanged();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setChanged() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.level.isClientSide()) {
                ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
                for (ServerPlayer player : Util.tracking(serverLevel, this.getBlockPos())) {
                    player.connection.send((Packet)updatePacket);
                }
            }
        }
        super.setChanged();
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.size = compoundTag.getInt("size");
        this.inventory = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putInt("size", this.size);
        super.saveAdditional(compoundTag, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setInventory(NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.inventory.set(i, (Object)((ItemStack)inventory.get(i)));
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }
}

