/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FlowerPotBlockEntity
extends BlockEntity {
    private Item flower;
    public static final String FLOWER_KEY = "flower";

    public FlowerPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DoApiBlockEntityTypes.FLOWER_POT_ENTITY.get(), pos, state);
    }

    public Item getFlower() {
        return this.flower;
    }

    public void setFlower(Item flower) {
        this.flower = flower;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.writeFlower(compoundTag, this.flower, provider);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.flower = this.readFlower(compoundTag, provider);
    }

    public void writeFlower(CompoundTag nbt, Item flower, HolderLookup.Provider provider) {
        CompoundTag nbtCompound = new CompoundTag();
        if (flower != null) {
            flower.getDefaultInstance().save(provider);
        }
        nbt.put(FLOWER_KEY, (Tag)nbtCompound);
    }

    public Item readFlower(CompoundTag nbt, HolderLookup.Provider provider) {
        CompoundTag nbtCompound;
        super.loadAdditional(nbt, provider);
        if (nbt.contains(FLOWER_KEY) && !(nbtCompound = nbt.getCompound(FLOWER_KEY)).isEmpty()) {
            return ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt).getItem();
        }
        return null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : GeneralUtil.tracking((ServerLevel)this.level, this.getBlockPos())) {
                player.connection.send((Packet)updatePacket);
            }
        }
        super.setChanged();
    }
}

