/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import com.mojang.serialization.MapCodec;
import de.cristelknight.doapi.common.block.entity.StandardBlockEntity;
import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StandardBlock
extends BaseEntityBlock {
    public static final MapCodec<StandardBlock> CODEC = StandardBlock.simpleCodec(StandardBlock::new);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public StandardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.makeDefaultState();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_DOBLOCKDROPS)).get() && state.getBlock() != newState.getBlock()) {
            StandardBlockEntity entity;
            Item item;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof StandardBlockEntity && (item = (entity = (StandardBlockEntity)blockEntity).getItem()) != null) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)item));
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected void makeDefaultState() {
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        Item item;
        Optional entity = levelReader.getBlockEntity(blockPos, (BlockEntityType)DoApiBlockEntityTypes.STANDARD.get());
        if (entity.isPresent() && (item = ((StandardBlockEntity)((Object)entity.get())).getItem()) != null) {
            return new ItemStack((ItemLike)item);
        }
        return super.getCloneItemStack(levelReader, blockPos, blockState);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new StandardBlockEntity(blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        level.getBlockEntity(blockPos, (BlockEntityType)DoApiBlockEntityTypes.STANDARD.get()).ifPresent(entity -> entity.fromItem(itemStack));
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos.below()).isSolid();
    }

    public boolean isPossibleToRespawnInThis(BlockState blockState) {
        return true;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(blockPlaceContext.getRotation() + 180.0f))));
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)blockState.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)blockState.getValue((Property)ROTATION)).intValue(), 16)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return StandardBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DoApiBlockEntityTypes.STANDARD.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (StandardBlockEntity)be));
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }
}

