/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StackableEatableBlock
extends Block {
    private static final IntegerProperty STACK_PROPERTY = IntegerProperty.create((String)"stack", (int)1, (int)8);
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final int maxStack;
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public StackableEatableBlock(BlockBehaviour.Properties settings, int maxStack) {
        super(settings);
        this.maxStack = maxStack;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STACK_PROPERTY, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STACK_PROPERTY, FACING});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (player.isShiftKeyDown() && stack.isEmpty()) {
            if (!world.isClientSide) {
                if ((Integer)state.getValue((Property)STACK_PROPERTY) > 1) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.getValue((Property)STACK_PROPERTY) - 1)), 3);
                } else {
                    world.removeBlock(pos, false);
                }
                player.getFoodData().eat(3, 0.6f);
                world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        } else if (stack.getItem() == this.asItem()) {
            if ((Integer)state.getValue((Property)STACK_PROPERTY) < this.maxStack) {
                world.setBlock(pos, (BlockState)state.setValue((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.getValue((Property)STACK_PROPERTY) + 1)), 3);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.isEmpty()) {
            if ((Integer)state.getValue((Property)STACK_PROPERTY) > 1) {
                world.setBlock(pos, (BlockState)state.setValue((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.getValue((Property)STACK_PROPERTY) - 1)), 3);
            } else if ((Integer)state.getValue((Property)STACK_PROPERTY) == 1) {
                world.destroyBlock(pos, false);
            }
            Direction direction = player.getDirection().getOpposite();
            double xMotion = (double)direction.getStepX() * 0.13;
            double yMotion = 0.35;
            double zMotion = (double)direction.getStepZ() * 0.13;
            GeneralUtil.spawnSlice(world, new ItemStack((ItemLike)this), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, xMotion, yMotion, zMotion);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, blockHitResult);
    }
}

