/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.common.item.ICustomHat;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

@Deprecated
public class CustomHatFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public final Map<Item, EntityModel<T>> MODELS = Maps.newHashMap();
    private final EntityModelSet modelLoader;
    private final float yOffset;

    public CustomHatFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelSet) {
        this(context, modelSet, 0.0f);
    }

    public CustomHatFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelLoader, float yOffset) {
        super(context);
        this.yOffset = yOffset;
        this.modelLoader = modelLoader;
    }

    public EntityModel<T> getHatModel(T entity, EquipmentSlot slot) {
        ICustomHat hatItem = this.getHat(entity, slot);
        if (hatItem instanceof Item) {
            Item item = (Item)hatItem;
            if (this.MODELS.isEmpty()) {
                List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
                for (DoApiAPI api : apis) {
                    api.registerHat(this.MODELS, this.modelLoader);
                }
            }
            return this.MODELS.get(item);
        }
        return null;
    }

    public ICustomHat getHat(T entity, EquipmentSlot slot) {
        ItemStack headSlot = entity.getItemBySlot(slot);
        Item item = headSlot.getItem();
        if (item instanceof ICustomHat) {
            ICustomHat hat = (ICustomHat)item;
            if (!headSlot.isEmpty()) {
                return hat;
            }
        }
        return null;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EquipmentSlot[] slots;
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            Item item;
            EntityModel<T> headModel = this.getHatModel(entity, slot);
            ItemStack hatStack = entity.getItemBySlot(slot);
            if (headModel == null || !((item = hatStack.getItem()) instanceof ICustomHat)) continue;
            ICustomHat hatItem = (ICustomHat)item;
            matrices.pushPose();
            this.setupHat(matrices, slot, hatItem.getOffset().floatValue());
            VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(entity, slot)), (boolean)hatStack.hasFoil());
            if (hatStack.is(ItemTags.DYEABLE)) {
                int color = ((DyedItemColor)hatStack.get(DataComponents.DYED_COLOR)).rgb();
                headModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
            } else {
                headModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
            }
            matrices.popPose();
        }
    }

    public void setupHat(PoseStack matrices, EquipmentSlot slot, float extraYOffset) {
        if (slot == EquipmentSlot.HEAD) {
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(matrices);
        }
        matrices.scale(1.0f, 1.0f, 1.0f);
        matrices.translate(0.0f, this.yOffset + extraYOffset, 0.0f);
    }

    protected ResourceLocation getTexture(T entity, EquipmentSlot slot) {
        ICustomHat customItem = this.getHat(entity, slot);
        if (customItem != null) {
            return customItem.getTexture();
        }
        return super.getTextureLocation(entity);
    }
}

