/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.PrivateRecipeBookGhostSlots;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.PrivateRecipeBookRecipeArea;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeGroupButtonWidget;
import de.cristelknight.doapi.config.builtin.RBConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class PrivateRecipeBookWidget
implements PlaceRecipe<Ingredient>,
Renderable,
GuiEventListener,
RecipeShownListener {
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled_highlighted"));
    public static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/recipe_book.png");
    private static final Component SEARCH_HINT_TEXT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private static final Component TOGGLE_CRAFTABLE_RECIPES_TEXT = Component.translatable((String)"gui.recipebook.toggleRecipes.craftable");
    private static final Component TOGGLE_ALL_RECIPES_TEXT = Component.translatable((String)"gui.recipebook.toggleRecipes.all");
    protected final PrivateRecipeBookGhostSlots ghostSlots = new PrivateRecipeBookGhostSlots();
    private final List<PrivateRecipeGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    private PrivateRecipeGroupButtonWidget currentTab;
    protected StateSwitchingButton toggleCraftableButton;
    protected AbstractPrivateRecipeScreenHandler screenHandler;
    @Nullable
    private EditBox searchField;
    private int leftOffset;
    private int parentWidth;
    private int parentHeight;
    protected Minecraft client;
    private String searchText = "";
    private final PrivateRecipeBookRecipeArea recipesArea = new PrivateRecipeBookRecipeArea();
    private final StackedContents recipeFinder = new StackedContents();
    private int cachedInvChangeCount;
    private boolean searching;
    private boolean open;
    private boolean narrow;

    protected abstract RecipeType<? extends Recipe<RecipeInput>> getRecipeType();

    public abstract void insertRecipe(Recipe<?> var1);

    public abstract void showGhostRecipe(Recipe<?> var1, List<Slot> var2, RegistryAccess var3);

    public void initialize(int parentWidth, int parentHeight, Minecraft client, boolean narrow, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.client = client;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.screenHandler = craftingScreenHandler;
        this.narrow = narrow;
        assert (client.player != null);
        client.player.containerMenu = craftingScreenHandler;
        this.cachedInvChangeCount = client.player.getInventory().getTimesChanged();
        this.open = this.isGuiOpen();
        if (this.open) {
            this.reset();
        }
    }

    protected void setOpen(boolean opened) {
        if (opened) {
            this.reset();
        }
        this.open = opened;
        RBConfig.setRecipeBookOpenToggle(opened);
        if (!opened) {
            this.recipesArea.hideAlternates();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private boolean isGuiOpen() {
        return ((RBConfig)RBConfig.DEFAULT.getConfig()).recipeBookOpen();
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    private boolean toggleFilteringCraftable() {
        boolean bl = !((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle();
        RBConfig.setCraftableToggle(bl);
        return bl;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isOpen()) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 100.0);
            int i = (this.parentWidth - 147) / 2 - this.leftOffset;
            int j = (this.parentHeight - 166) / 2;
            guiGraphics.blit(TEXTURE, i, j, 1, 1, 147, 166);
            if (!this.searchField.isFocused() && this.searchField.getValue().isEmpty()) {
                guiGraphics.drawString(this.client.font, SEARCH_HINT_TEXT, i + 25, j + 14, -1);
            } else {
                this.searchField.render(guiGraphics, mouseX, mouseY, delta);
            }
            for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
                recipeGroupButtonWidget.render(guiGraphics, mouseX, mouseY, delta);
            }
            this.toggleCraftableButton = new StateSwitchingButton(i + 110, j + 12, 26, 16, ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle());
            this.setCraftableButtonTexture();
            this.toggleCraftableButton.render(guiGraphics, mouseX, mouseY, delta);
            this.recipesArea.draw(guiGraphics, i, j, mouseX, mouseY, delta);
            poseStack.popPose();
        }
    }

    public void drawGhostSlots(GuiGraphics guiGraphics, int x, int y, boolean bl, float delta) {
        this.ghostSlots.draw(guiGraphics, this.client, x, y, bl, delta);
    }

    public void drawTooltip(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isOpen()) {
            this.recipesArea.drawTooltip(guiGraphics, mouseX, mouseY);
            if (this.toggleCraftableButton.isHovered()) {
                Component text = this.getCraftableButtonText();
                if (this.client.screen != null) {
                    guiGraphics.renderTooltip(this.client.font, text, mouseX, mouseY);
                }
            }
            this.drawGhostSlotTooltip(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    private void drawGhostSlotTooltip(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        ItemStack itemStack = null;
        for (int i = 0; i < this.ghostSlots.getSlotCount(); ++i) {
            PrivateRecipeBookGhostSlots.PrivateGhostInputSlot ghostInputSlot = this.ghostSlots.getSlot(i);
            int j = ghostInputSlot.getX() + x;
            int k = ghostInputSlot.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16) continue;
            itemStack = ghostInputSlot.getCurrentItemStack();
        }
        if (itemStack != null && this.client.screen != null) {
            guiGraphics.renderTooltip(this.client.font, itemStack, mouseX, mouseY);
        }
    }

    public void update() {
        boolean open = this.isGuiOpen();
        if (this.isOpen() != open) {
            this.setOpen(open);
        }
        if (this.isOpen() && this.cachedInvChangeCount != this.client.player.getInventory().getTimesChanged()) {
            this.refreshInputs();
            this.cachedInvChangeCount = this.client.player.getInventory().getTimesChanged();
        }
    }

    private void refreshResults(boolean resetCurrentPage) {
        if (this.currentTab == null) {
            return;
        }
        if (this.searchField == null) {
            return;
        }
        List recipes = this.getResultsForGroup(this.currentTab.getGroup(), this.client.level.getRecipeManager().getAllRecipesFor(this.getRecipeType()));
        String string = this.searchField.getValue();
        if (!string.isEmpty()) {
            recipes.removeIf(recipe -> !recipe.getResultItem((HolderLookup.Provider)this.client.level.registryAccess()).getHoverName().getString().toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle()) {
            recipes.removeIf(recipe -> !this.screenHandler.hasIngredient((Recipe<?>)recipe));
        }
        this.recipesArea.setResults(recipes, resetCurrentPage);
    }

    private <C extends RecipeInput, T extends Recipe<C>> List<T> getResultsForGroup(IRecipeBookGroup group, List<RecipeHolder<T>> recipes) {
        ArrayList results = Lists.newArrayList();
        for (RecipeHolder<T> recipe : recipes) {
            if (!group.fitRecipe((Recipe<? extends RecipeInput>)recipe.value(), this.client.level.registryAccess())) continue;
            results.add(recipe.value());
        }
        return results;
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int j = (this.parentHeight - 166) / 2 + 3;
        int l = 0;
        for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
            recipeGroupButtonWidget.visible = true;
            recipeGroupButtonWidget.setPosition(i, j + 27 * l++);
        }
    }

    private void refreshInputs() {
        this.recipeFinder.clear();
        this.client.player.getInventory().fillStackedContents(this.recipeFinder);
        this.refreshResults(false);
    }

    public void reset() {
        this.leftOffset = this.narrow ? 0 : 86;
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 166) / 2;
        this.recipeFinder.clear();
        this.client.player.getInventory().fillStackedContents(this.recipeFinder);
        String string = this.searchField != null ? this.searchField.getValue() : "";
        Font var10003 = this.client.font;
        int var10004 = i + 25;
        int var10005 = j + 14;
        Objects.requireNonNull(this.client.font);
        this.searchField = new EditBox(var10003, var10004, var10005, 80, 14, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchField.setMaxLength(50);
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setValue(string);
        this.recipesArea.initialize(this.client, i, j, this.screenHandler);
        this.toggleCraftableButton = new StateSwitchingButton(i + 110, j + 12, 26, 16, ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle());
        this.tabButtons.clear();
        for (IRecipeBookGroup recipeBookGroup : this.screenHandler.getGroups()) {
            this.tabButtons.add(new PrivateRecipeGroupButtonWidget(recipeBookGroup));
        }
        if (this.currentTab != null) {
            this.currentTab = this.tabButtons.stream().filter(button -> button.getGroup().equals(this.currentTab.getGroup())).findFirst().orElse(null);
        }
        if (this.currentTab == null) {
            this.currentTab = this.tabButtons.get(0);
        }
        this.currentTab.setStateTriggered(true);
        this.refreshResults(false);
        this.setCraftableButtonTexture();
        this.refreshTabButtons();
    }

    public void slotClicked(@Nullable Slot slot) {
        if (slot != null && slot.index < this.screenHandler.getCraftingSlotCount()) {
            this.ghostSlots.reset();
            if (this.isOpen()) {
                this.refreshInputs();
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.open && !this.client.player.isSpectator()) {
            PrivateRecipeGroupButtonWidget vineryRecipeGroupButtonWidget;
            if (this.recipesArea.mouseClicked(mouseX, mouseY, button)) {
                Recipe<?> recipe = this.recipesArea.getLastClickedRecipe();
                Recipe<?> recipeBookRecipe = this.recipesArea.getLastClickedRecipe();
                if (recipe != null) {
                    if (this.currentTab == null) {
                        return false;
                    }
                    this.ghostSlots.reset();
                    assert (recipeBookRecipe != null);
                    if (!this.screenHandler.hasIngredient(recipe)) {
                        this.showGhostRecipe(recipe, (List<Slot>)this.screenHandler.slots, this.client.level.registryAccess());
                        return false;
                    }
                    this.ghostSlots.reset();
                    this.insertRecipe(recipe);
                    this.refreshResults(false);
                }
                return true;
            }
            if (this.searchField.mouseClicked(mouseX, mouseY, button)) {
                this.searchField.setFocused(true);
                return true;
            }
            if (this.toggleCraftableButton.mouseClicked(mouseX, mouseY, button)) {
                this.searchField.setFocused(false);
                boolean bl = this.toggleFilteringCraftable();
                this.toggleCraftableButton.setStateTriggered(bl);
                this.refreshResults(false);
                return true;
            }
            Iterator<PrivateRecipeGroupButtonWidget> var6 = this.tabButtons.iterator();
            do {
                if (var6.hasNext()) continue;
                return false;
            } while (!(vineryRecipeGroupButtonWidget = var6.next()).mouseClicked(mouseX, mouseY, button));
            if (this.currentTab != vineryRecipeGroupButtonWidget) {
                if (this.currentTab != null) {
                    this.currentTab.setStateTriggered(false);
                }
                this.currentTab = vineryRecipeGroupButtonWidget;
                this.currentTab.setStateTriggered(true);
                this.refreshResults(true);
            }
            return false;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        if (this.isOpen() && !this.client.player.isSpectator()) {
            if (keyCode == 256 && !this.isWide()) {
                this.setOpen(false);
                return true;
            }
            if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
                this.refreshSearchResults();
                return true;
            }
            if (this.searchField.isFocused() && this.searchField.isVisible() && keyCode != 256) {
                return true;
            }
            if (this.client.options.keyChat.matches(keyCode, scanCode) && !this.searchField.isFocused()) {
                this.searching = true;
                this.searchField.setFocused(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.searching) {
            return false;
        }
        if (this.isOpen() && !this.client.player.isSpectator() && this.searchField.charTyped(chr, modifiers)) {
            this.refreshSearchResults();
            return true;
        }
        return false;
    }

    private void refreshSearchResults() {
        String string = this.searchField.getValue().toLowerCase(Locale.ROOT);
        this.triggerPrivateEasterEgg(string);
        if (!string.equals(this.searchText)) {
            this.refreshResults(false);
            this.searchText = string;
        }
    }

    private void triggerPrivateEasterEgg(String search) {
        String text;
        String name;
        switch (search) {
            case "misslilitu": {
                name = "MissLilitu";
                text = "Boo!";
                break;
            }
            case "satisfy": {
                name = "satisfy";
                text = "Boo!";
                break;
            }
            case "cristelknight": {
                name = "CristelKnight";
                text = "Boo!";
                break;
            }
            case "bmjo": {
                name = "BaumeisterJO";
                text = "42";
                break;
            }
            default: {
                return;
            }
        }
        LocalPlayer playerEntity = this.client.player;
        assert (playerEntity != null);
        playerEntity.sendSystemMessage(Component.nullToEmpty((String)("<" + name + "> " + text)));
        playerEntity.playSound(SoundEvents.FIREWORK_ROCKET_TWINKLE, 0.5f, 1.0f);
    }

    public boolean isClickOutsideBounds(double mouseX, double mouseY, int x, int y, int backgroundWidth, int backgroundHeight) {
        if (!this.isOpen()) {
            return true;
        }
        boolean bl = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + backgroundWidth) || mouseY >= (double)(y + backgroundHeight);
        boolean bl2 = (double)(x - 147) < mouseX && mouseX < (double)x && (double)y < mouseY && mouseY < (double)(y + backgroundHeight);
        return bl && !bl2 && !this.currentTab.isHovered();
    }

    protected void setCraftableButtonTexture() {
        this.toggleCraftableButton.initTextureValues(FILTER_BUTTON_SPRITES);
    }

    protected Component getToggleCraftableButtonText() {
        return TOGGLE_CRAFTABLE_RECIPES_TEXT;
    }

    private Component getCraftableButtonText() {
        return this.toggleCraftableButton.isStateTriggered() ? this.getToggleCraftableButtonText() : TOGGLE_ALL_RECIPES_TEXT;
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int i = this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return i;
    }

    private boolean isWide() {
        return this.leftOffset == 86;
    }

    public void addItemToSlot(Ingredient object, int i, int j, int k, int l) {
    }
}

