/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block.entity;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.CommonAbstractions;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.barteringstation.world.level.block.entity.BarteringStationAnimationController;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BarteringStationBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
ListBackedContainer,
TickingBlockEntity {
    public static final MutableComponent CONTAINER_BARTERING_STATION = Component.translatable((String)"container.bartering_station");
    public static final String TAG_DELAY = BarteringStation.id("delay").toString();
    public static final int ALL_SLOTS = 21;
    public static final int CURRENCY_SLOTS = 6;
    public static final int DATA_SLOTS = 2;
    private static final int[] SLOTS_FOR_INPUT = (int[])Util.make((Object)new int[6], arr -> Arrays.setAll(arr, IntUnaryOperator.identity()));
    private static final int[] SLOTS_FOR_OUTPUT = (int[])Util.make((Object)new int[15], arr -> Arrays.setAll(arr, i -> i + 6));
    private final BarteringStationAnimationController animationController;
    private final ContainerData dataAccess;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)21, (Object)ItemStack.EMPTY);
    private int barterDelay;
    private int nearbyPiglins;

    public BarteringStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
        this.animationController = new BarteringStationAnimationController(blockPos);
        this.dataAccess = new ContainerData(){

            public int get(int id) {
                return switch (id) {
                    case 0 -> BarteringStationBlockEntity.this.getBarterDelay();
                    case 1 -> BarteringStationBlockEntity.this.nearbyPiglins;
                    default -> throw new IndexOutOfBoundsException(id);
                };
            }

            public void set(int id, int data) {
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public int getBarterDelay() {
        return Math.min(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay, this.barterDelay);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.barterDelay = tag.getShort(TAG_DELAY);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putShort(TAG_DELAY, (short)this.barterDelay);
    }

    protected Component getDefaultName() {
        return CONTAINER_BARTERING_STATION;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.getContainerItems();
    }

    protected void setItems(NonNullList<ItemStack> items) {
        ContainerMenuHelper.copyItemsIntoList(items, this.getContainerItems());
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new BarteringStationMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public void clientTick() {
        this.animationController.tick(this.getLevel());
    }

    public void serverTick() {
        int totalBarterDelay;
        boolean tryPerformBarter;
        if (this.barterDelay > 0) {
            --this.barterDelay;
        }
        boolean bl = tryPerformBarter = this.barterDelay % (totalBarterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay) == 0;
        if (tryPerformBarter || this.barterDelay % (totalBarterDelay / 4) == 0) {
            List<Piglin> piglins = BarteringStationBlockEntity.findNearbyPiglins(this.getLevel(), this.getBlockPos());
            this.nearbyPiglins = piglins.size();
            if (tryPerformBarter) {
                this.barterDelay = totalBarterDelay * 2;
                this.barterWithPiglins(this.getBlockPos(), piglins);
            }
        }
    }

    private static List<Piglin> findNearbyPiglins(Level level, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        int horizontalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).horizontalRange;
        int verticalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).verticalRange;
        return level.getEntitiesOfClass(Piglin.class, new AABB(vec3.add((double)(-horizontalRange), (double)(-verticalRange), (double)(-horizontalRange)), vec3.add((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), AbstractPiglin::isAdult);
    }

    private void barterWithPiglins(BlockPos pos, List<Piglin> piglins) {
        if (piglins.isEmpty() || this.findFreeResponseSlot().isEmpty()) {
            return;
        }
        int currentPiglin = 0;
        block0: for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            while (currentPiglin < piglins.size()) {
                if (!BarteringStationBlockEntity.mobInteract(piglins.get(currentPiglin++), stack, pos)) continue;
                this.setChanged();
                this.barterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
                continue block0;
            }
        }
    }

    private OptionalInt findFreeResponseSlot() {
        for (int i = 6; i < this.getContainerSize(); ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static boolean mobInteract(Piglin piglin, ItemStack itemStack, BlockPos blockPos) {
        if (PiglinAi.canAdmire((Piglin)piglin, (ItemStack)itemStack)) {
            ItemStack currencyStack = itemStack.split(1);
            PiglinAi.holdInOffhand((Piglin)piglin, (ItemStack)currencyStack);
            BarteringStationBlockEntity.admireGoldItem((LivingEntity)piglin);
            PiglinAi.stopWalking((Piglin)piglin);
            ((BarteringStationCapability)ModRegistry.BARTERING_STATION_CAPABILITY.get((Object)piglin)).setBarteringStationPos(blockPos);
            return true;
        }
        return false;
    }

    private static void admireGoldItem(LivingEntity livingEntity) {
        livingEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, (long)(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay / 2));
    }

    public BarteringStationAnimationController getAnimationController() {
        return this.animationController;
    }

    public int[] getSlotsForFace(Direction direction) {
        return direction == Direction.DOWN ? SLOTS_FOR_OUTPUT : SLOTS_FOR_INPUT;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemStack, Direction direction) {
        return true;
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index >= 0 && index < 6 && CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
    }

    public boolean placeBarterResponseItem(ItemStack stack) {
        while (!stack.isEmpty()) {
            OptionalInt slot = this.findResponseSlotWithSpace(stack);
            if (slot.isEmpty()) {
                slot = this.findFreeResponseSlot();
            }
            if (!slot.isPresent()) break;
            this.mergeStackToSlot(stack, slot.getAsInt());
            if (!stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private OptionalInt findResponseSlotWithSpace(ItemStack stack) {
        for (int i = 6; i < this.getContainerSize(); ++i) {
            if (!this.hasSpaceForItem(this.getItem(i), stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void mergeStackToSlot(ItemStack stackToMerge, int targetSlot) {
        ItemStack stackToInsert;
        ItemStack stackInSlot = this.getItem(targetSlot);
        if (stackInSlot.isEmpty()) {
            stackToInsert = stackToMerge.copyAndClear();
        } else {
            stackToInsert = stackInSlot.copy();
            int transferAmount = stackToMerge.getCount();
            transferAmount = Math.min(transferAmount, stackToInsert.getMaxStackSize() - stackToInsert.getCount());
            stackToInsert.grow(transferAmount);
            stackToMerge.shrink(transferAmount);
        }
        this.setItem(targetSlot, stackToInsert);
    }

    private boolean hasSpaceForItem(ItemStack stack1, ItemStack stack2) {
        return !stack1.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2) && stack1.isStackable() && stack1.getCount() < stack1.getMaxStackSize() && stack1.getCount() < this.getMaxStackSize();
    }
}

