/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ClientConfig;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.puzzleslib.api.client.gui.v2.screen.ScreenHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BarteringStationScreen
extends AbstractContainerScreen<BarteringStationMenu> {
    public static final String KEY_NEARBY_PIGLINS = "gui.barteringstation.bartering_station.piglins";
    public static final ResourceLocation BARTERING_STATION_LOCATION = BarteringStation.id("textures/gui/container/bartering_station.png");
    public static final int ARROW_SIZE_X = 24;
    public static final int ARROW_SIZE_Y = 18;

    public BarteringStationScreen(BarteringStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    private static Component getPiglinComponent(int nearbyPiglins) {
        return Component.literal((String)String.valueOf(nearbyPiglins)).withStyle(nearbyPiglins > 0 ? ChatFormatting.GOLD : ChatFormatting.RED);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.overlay()) {
            this.renderCooldownOverlays(guiGraphics);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (ScreenHelper.isHovering((int)(this.leftPos + 53), (int)(this.topPos + 20), (int)16, (int)16, (double)mouseX, (double)mouseY)) {
            MutableComponent component = Component.translatable((String)KEY_NEARBY_PIGLINS, (Object[])new Object[]{BarteringStationScreen.getPiglinComponent(((BarteringStationMenu)this.menu).getNearbyPiglins())});
            guiGraphics.renderTooltip(this.font, (Component)component, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BARTERING_STATION_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.arrows()) {
            this.renderCooldownArrows(guiGraphics);
        }
        guiGraphics.pose().pushPose();
        int posX = this.leftPos + 53;
        int posY = this.topPos + 20;
        guiGraphics.renderFakeItem(new ItemStack((ItemLike)Items.PIGLIN_HEAD), posX, posY);
        Component component = BarteringStationScreen.getPiglinComponent(((BarteringStationMenu)this.menu).getNearbyPiglins());
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        guiGraphics.drawString(this.font, component, posX + 19 - 2 - this.font.width((FormattedText)component), posY + 6 + 3, -1);
        guiGraphics.pose().popPose();
    }

    private void renderCooldownArrows(GuiGraphics guiGraphics) {
        int topArrowProgress = ((BarteringStationMenu)this.menu).getTopArrowProgress();
        guiGraphics.blit(BARTERING_STATION_LOCATION, this.leftPos + 49, this.topPos + 40, 176, 0, topArrowProgress, 18);
        int bottomArrowProgress = ((BarteringStationMenu)this.menu).getBottomArrowProgress();
        guiGraphics.blit(BARTERING_STATION_LOCATION, this.leftPos + 49 + 24 - bottomArrowProgress, this.topPos + 53, 200 - bottomArrowProgress, 18, bottomArrowProgress, 18);
    }

    private void renderCooldownOverlays(GuiGraphics guiGraphics) {
        float cooldownProgress = ((BarteringStationMenu)this.menu).getCooldownProgress();
        if (cooldownProgress > 0.0f && cooldownProgress < 1.0f) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.leftPos, (double)this.topPos, 0.0);
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 6 && i < ((BarteringStationMenu)this.menu).slots.size(); ++i) {
                Slot slot = (Slot)((BarteringStationMenu)this.menu).slots.get(i);
                if (!slot.isActive() || !slot.hasItem()) continue;
                int startY = Mth.floor((float)(16.0f * (1.0f - cooldownProgress)));
                guiGraphics.fill(RenderType.guiOverlay(), slot.x, slot.y + startY, slot.x + 16, slot.y + startY + Mth.ceil((float)(16.0f * cooldownProgress)), -2130706433);
            }
            guiGraphics.pose().popPose();
            RenderSystem.enableDepthTest();
        }
    }
}

