/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.bottledair_common_neoforge.events;

import com.natamus.bottledair_common_neoforge.config.ConfigHandler;
import com.natamus.bottledair_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AirEvent {
    public static InteractionResultHolder<ItemStack> onBottleClick(Player player, Level level, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isInWater()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Item stackitem = itemStack.getItem();
        if (!stackitem.equals(Items.GLASS_BOTTLE)) {
            PotionContents potionContents;
            if (ConfigHandler.disableWaterConsumptionUnderwater && stackitem.equals(Items.POTION) && (potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER) && player.isUnderWater()) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            return InteractionResultHolder.pass((Object)itemStack);
        }
        int maxair = player.getMaxAirSupply();
        int air = player.getAirSupply();
        if (air >= maxair) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        int newair = air + ConfigHandler.amountOfAirInBottles;
        if (newair > maxair) {
            newair = maxair;
        }
        player.setAirSupply(newair);
        InteractionHand otherhand = PlayerFunctions.getOtherHand((InteractionHand)hand);
        ItemStack otherstack = player.getItemInHand(otherhand);
        Item otheritem = otherstack.getItem();
        if (!Util.firetypeitems.contains(otheritem)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Inventory inv = player.getInventory();
        for (int i = 35; i > 0; --i) {
            PotionContents potionContents;
            ItemStack slot = inv.getItem(i);
            Item slotitem = slot.getItem();
            if (!slotitem.equals(Items.POTION) || !(potionContents = (PotionContents)slot.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) continue;
            slot.shrink(1);
            double num = GlobalVariables.random.nextDouble();
            if (!(num > ConfigHandler.chanceGlassBottleBreaksWithFireTypeInOffhand)) break;
            ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE, 1));
            break;
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }
}

