/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.world.item.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.init.ModRegistry;
import fuzs.bagofholding.world.item.BagType;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.provider.ItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.impl.ContainerProvider;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class BagProvider
extends ContainerProvider {
    public static final MapCodec<BagProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BagType.CODEC.fieldOf("bag_type").forGetter(provider -> provider.bagType), (App)BagProvider.backgroundColorCodec(), (App)BagProvider.disallowedItemsCodec(), (App)BagProvider.filterContainerItemsCodec(), (App)BagProvider.interactionPermissionsCodec(), (App)BagProvider.equipmentSlotsCodec()).apply((Applicative)instance, (bagType, dyeColor, disallowedItems, filterContainerItems, interactionPermissions, equipmentSlots) -> new BagProvider((BagType)((Object)((Object)bagType)), dyeColor.orElse(null)).disallowedItems((HolderSet)disallowedItems).filterContainerItems((boolean)filterContainerItems).interactionPermissions((ContainerProvider.InteractionPermissions)interactionPermissions).equipmentSlots((EquipmentSlotGroup)equipmentSlots)));
    private final BagType bagType;

    public BagProvider(BagType bagType, @Nullable DyeBackedColor dyeColor) {
        super(-1, -1, dyeColor);
        this.bagType = bagType;
    }

    public BagProvider disallowedItems(HolderSet<Item> disallowedItems) {
        return (BagProvider)super.disallowedItems(disallowedItems);
    }

    public BagProvider filterContainerItems(boolean filterContainerItems) {
        return (BagProvider)super.filterContainerItems(filterContainerItems);
    }

    public BagProvider interactionPermissions(ContainerProvider.InteractionPermissions interactionPermissions) {
        return (BagProvider)super.interactionPermissions(interactionPermissions);
    }

    public BagProvider equipmentSlots(EquipmentSlotGroup equipmentSlots) {
        return (BagProvider)super.equipmentSlots(equipmentSlots);
    }

    public float[] getBackgroundColor() {
        return super.getBackgroundColor();
    }

    public int getInventoryWidth() {
        return 9;
    }

    public int getInventoryHeight() {
        return switch (this.bagType) {
            default -> throw new MatchException(null, null);
            case BagType.LEATHER -> ((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).leatherBagRows;
            case BagType.IRON -> ((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).ironBagRows;
            case BagType.GOLDEN -> ((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).goldenBagRows;
        };
    }

    public ItemContentsProvider.Type getType() {
        return (ItemContentsProvider.Type)ModRegistry.BAG_ITEM_CONTENTS_PROVIDER_TYPE.value();
    }
}

