/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.world.item;

import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.network.S2CLockSlotMessage;
import fuzs.bagofholding.world.inventory.BagItemMenu;
import fuzs.bagofholding.world.inventory.LockableInventorySlot;
import fuzs.iteminteractions.api.v1.ItemContentsHelper;
import fuzs.iteminteractions.api.v1.provider.ItemContentsBehavior;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class BagOfHoldingItem
extends Item {
    private final Holder<MenuType<BagItemMenu>> menuType;

    public BagOfHoldingItem(Item.Properties properties, Holder<MenuType<BagItemMenu>> menuType) {
        super(properties);
        this.menuType = menuType;
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return itemStack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (player.isSecondaryUseActive() || !((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).sneakToOpenBag) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!level.isClientSide) {
                player.openMenu(this.getMenuProvider(itemInHand));
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                this.lockMySlot(player, itemInHand);
            }
            player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide);
        }
        return super.use(level, player, interactionHand);
    }

    private MenuProvider getMenuProvider(ItemStack itemStack) {
        return new SimpleMenuProvider((containerId, inventory, player) -> {
            ItemContentsBehavior behavior = ItemContentsHelper.getItemContentsBehavior((ItemStack)itemStack);
            SimpleContainer itemContainer = behavior.getItemContainer(itemStack, player);
            return new BagItemMenu(this.menuType, behavior, containerId, inventory, (Container)itemContainer);
        }, itemStack.getHoverName());
    }

    private void lockMySlot(Player player, ItemStack itemStack) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof BagItemMenu)) {
            return;
        }
        BagItemMenu menu = (BagItemMenu)abstractContainerMenu;
        NonNullList items = menu.getItems();
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i) != itemStack) continue;
            ((LockableInventorySlot)menu.getSlot(i)).lock();
            BagOfHolding.NETWORK.sendTo((ServerPlayer)player, new S2CLockSlotMessage(menu.containerId, i).toClientboundMessage());
            return;
        }
    }

    public void onDestroyed(ItemEntity itemEntity) {
        SimpleContainer container = ItemContentsHelper.getItemContentsBehavior((ItemStack)itemEntity.getItem()).getItemContainer(itemEntity.getItem(), null);
        Stream<ItemStack> stream = container.getItems().stream().filter(Predicate.not(ItemStack::isEmpty));
        ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, stream.toList());
    }
}

