/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantmentlevelcapindicator_common_neoforge.mixin;

import com.mojang.datafixers.util.Pair;
import com.natamus.enchantmentlevelcapindicator_common_neoforge.config.ConfigHandler;
import com.natamus.enchantmentlevelcapindicator_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={EnchantmentScreen.class}, priority=1001)
public class EnchantmentScreenMixin {
    @ModifyVariable(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE_ASSIGN", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0))
    public List<Component> render_list(List<Component> list, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maxLevel;
        if (!ConfigHandler.showSymbolInEnchantmentTable) {
            return list;
        }
        Component component = list.getFirst();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return list;
        }
        Registry enchantmentRegistry = localPlayer.connection.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Pair<Enchantment, Integer> enchantmentPair = Util.parseRawComponentText(component, (Registry<Enchantment>)enchantmentRegistry);
        if (enchantmentPair == null) {
            return list;
        }
        Enchantment enchantment = (Enchantment)enchantmentPair.getFirst();
        int level = (Integer)enchantmentPair.getSecond();
        if (level < (maxLevel = enchantment.getMaxLevel())) {
            return list;
        }
        MutableComponent clueComponent = Enchantment.getFullname((Holder)enchantmentRegistry.wrapAsHolder((Object)enchantment), (int)level).copy();
        return new ArrayList<MutableComponent>(Arrays.asList(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{clueComponent.append(Util.getStarComponent())}).withStyle(ChatFormatting.WHITE)));
    }
}

