/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantmentlevelcapindicator_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.enchantmentlevelcapindicator_common_forge.config.ConfigHandler;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;

public class Util {
    @Nullable
    public static Pair<Enchantment, Integer> parseRawComponentText(Component component, Registry<Enchantment> enchantmentRegistry) {
        return Util.parseRawComponentText(component.toString(), enchantmentRegistry);
    }

    @Nullable
    public static Pair<Enchantment, Integer> parseRawComponentText(String rawText, Registry<Enchantment> enchantmentRegistry) {
        Enchantment enchantment;
        ResourceLocation enchantmentResourceLocation;
        String[] rawEnchSpl = rawText.split("enchantment.");
        if (rawEnchSpl.length < 2) {
            return null;
        }
        String rawEnchantment = rawEnchSpl[1].split("'")[0];
        try {
            enchantmentResourceLocation = ResourceLocation.parse((String)rawEnchantment.replace(".", ":"));
        }
        catch (ResourceLocationException ex) {
            return null;
        }
        int level = 1;
        if (rawEnchSpl.length > 2) {
            String rawEnchantmentLevel = rawEnchSpl[2].split("'")[0].replace("level.", "");
            if (!NumberFunctions.isNumeric((String)rawEnchantmentLevel)) {
                return null;
            }
            level = Integer.parseInt(rawEnchantmentLevel);
        }
        if ((enchantment = (Enchantment)enchantmentRegistry.get(enchantmentResourceLocation)) == null) {
            return null;
        }
        return Pair.of((Object)enchantment, (Object)level);
    }

    public static Component getStarComponent() {
        ChatFormatting symbolColour = ChatFormatting.getById((int)ConfigHandler.maxLevelSymbolColourIndex);
        if (symbolColour == null) {
            symbolColour = ChatFormatting.GOLD;
        }
        return Component.literal((String)(" " + ConfigHandler.maxLevelSymbol)).withStyle(symbolColour);
    }
}

