/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.crater;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.corgitaco.enhancedcelestials.util.FastNoise;
import dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructurePieceTypes;
import dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.crater.CraterStructure;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class CraterPiece
extends StructurePiece {
    protected static FastNoise fastNoise = (FastNoise)Util.make((Object)new FastNoise(20202), noise -> {
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.004f);
    });
    private final CraterStructure.PieceStructureInfo structureInfo;

    protected CraterPiece(CraterStructure.PieceStructureInfo structureInfo, int genDepth, BoundingBox boundingBox) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), genDepth, boundingBox);
        this.structureInfo = structureInfo;
    }

    public CraterPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), tag);
        this.structureInfo = (CraterStructure.PieceStructureInfo)((Pair)CraterStructure.PieceStructureInfo.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("crater_info")).result().orElseThrow()).getFirst();
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        compoundTag.put("crater_info", (Tag)CraterStructure.PieceStructureInfo.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.structureInfo).result().orElseThrow());
    }

    public void postProcess(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        double radius = this.structureInfo.baseRadiusX();
        double radiusZ = this.structureInfo.baseRadiusZ();
        double yRadius = 40.0;
        BlockPos origin = this.structureInfo.origin();
        int baseHeight = origin.getY();
        BlockPos subtract = origin.offset((int)(-radius), 0, (int)(-radiusZ));
        int startX = subtract.getX();
        int startZ = subtract.getZ();
        BlockPos add = origin.offset((int)radius, 0, (int)radiusZ);
        int endX = add.getX();
        int endZ = add.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int minX = Math.max(startX - 10, chunkPos.getMinBlockX());
        int maxX = Math.min(endX + 10, chunkPos.getMaxBlockX());
        int minZ = Math.max(startZ - 10, chunkPos.getMinBlockZ());
        int maxZ = Math.min(endZ + 10, chunkPos.getMaxBlockZ());
        double xRadiusSquared = radius * radius;
        double yRadiusSquared = yRadius * yRadius;
        double zRadiusSquared = radiusZ * radiusZ;
        for (int worldX = minX; worldX <= maxX; ++worldX) {
            int localX = worldX - origin.getX();
            mutable.set(worldX, 0, 0);
            for (int worldZ = minZ; worldZ <= maxZ; ++worldZ) {
                int localZ = worldZ - origin.getZ();
                mutable.set(worldX, 0, worldZ);
                for (double y = -yRadius; y <= yRadius; y += 1.0) {
                    mutable.set((double)worldX, (double)baseHeight + y, (double)worldZ);
                    double equationResult = (double)(localX * localX) / xRadiusSquared + y * y / yRadiusSquared + (double)(localZ * localZ) / zRadiusSquared;
                    double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable.getX(), mutable.getZ());
                    if (equationResult >= 1.0) continue;
                    worldGenLevel.setBlock((BlockPos)mutable, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }
}

