/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LocalMobCapCalculator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LocalMobCapCalculator.class})
public class MixinLocalMobCapCalculator {
    @Shadow
    @Final
    private ChunkMap chunkMap;

    @Redirect(method={"canSpawn(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/world/level/ChunkPos;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/LocalMobCapCalculator$MobCounts;canSpawn(Lnet/minecraft/world/entity/MobCategory;)Z"))
    private boolean useLunarEventMobCap(LocalMobCapCalculator.MobCounts instance, MobCategory mobCategory) {
        ServerLevel level = this.chunkMap.level;
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
            Object2IntMap counts = instance.counts;
            int currentCount = counts.getOrDefault((Object)mobCategory, 0);
            return (double)currentCount < (double)mobCategory.getMaxInstancesPerChunk() * data.currentLunarEvent().getSpawnMultiplierForMonsterCategory(mobCategory);
        }
        return instance.canSpawn(mobCategory);
    }
}

