/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnchantmentMenu.class})
public abstract class EnchantmentMenuMixin
extends AbstractContainerMenu {
    protected EnchantmentMenuMixin(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @ModifyExpressionValue(method={"lambda$slotsChanged$0(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantmentCost(Lnet/minecraft/util/RandomSource;IILnet/minecraft/world/item/ItemStack;)I")})
    private int modifyCost(int original, ItemStack stack, Level level, BlockPos pos) {
        Optional<EnhancedCelestialsLunarForecastWorldData> enhancedCelestialsLunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData(level);
        if (enhancedCelestialsLunarForecastWorldData.isEmpty()) {
            return original;
        }
        EnhancedCelestialsLunarForecastWorldData data = enhancedCelestialsLunarForecastWorldData.orElseThrow();
        double xp = data.currentLunarEvent().enchantmentTableCostAmplifier();
        return (int)((double)original * xp);
    }

    @WrapMethod(method={"getEnchantmentList"})
    private List<EnchantmentInstance> modifyEnchantmentList(RegistryAccess registryAccess, ItemStack stack, int slot, int cost, Operation<List<EnchantmentInstance>> original) {
        Player player = null;
        for (Slot slot1 : this.slots) {
            Container container = slot1.container;
            if (!(container instanceof Inventory)) continue;
            Inventory inventory = (Inventory)container;
            player = inventory.player;
            break;
        }
        if (player != null) {
            Optional<EnhancedCelestialsLunarForecastWorldData> enhancedCelestialsLunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData(player.level());
            if (enhancedCelestialsLunarForecastWorldData.isEmpty()) {
                return (List)original.call(new Object[]{registryAccess, stack, slot, cost});
            }
            EnhancedCelestialsLunarForecastWorldData data = enhancedCelestialsLunarForecastWorldData.orElseThrow();
            double enchantmentTableCostAmplifier = data.currentLunarEvent().enchantmentTableCostAmplifier();
            int ogCost = (int)((double)cost / enchantmentTableCostAmplifier);
            return (List)original.call(new Object[]{registryAccess, stack, slot, ogCost});
        }
        return (List)original.call(new Object[]{registryAccess, stack, slot, cost});
    }
}

