/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.client.model;

import dev.corgitaco.enhancedcelestials.entity.SpaceMossBugEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public final class SpaceMossBugModel
extends HierarchicalModel<SpaceMossBugEntity> {
    private final ModelPart root;
    private final ModelPart front_carapace;
    private final ModelPart back_carapace;
    private final ModelPart right_antenna;
    private final ModelPart left_antenna;
    private final ModelPart telson;
    private final ModelPart right_front_leg;
    private final ModelPart right_middle_leg;
    private final ModelPart right_back_leg;
    private final ModelPart left_front_leg;
    private final ModelPart left_middle_leg;
    private final ModelPart left_back_leg;

    public SpaceMossBugModel(ModelPart root) {
        this.root = root;
        this.front_carapace = root.getChild("front_carapace");
        this.back_carapace = root.getChild("back_carapace");
        this.right_antenna = root.getChild("right_antenna");
        this.left_antenna = root.getChild("left_antenna");
        this.telson = root.getChild("telson");
        this.right_front_leg = root.getChild("right_front_leg");
        this.right_middle_leg = root.getChild("right_middle_leg");
        this.right_back_leg = root.getChild("right_back_leg");
        this.left_front_leg = root.getChild("left_front_leg");
        this.left_middle_leg = root.getChild("left_middle_leg");
        this.left_back_leg = root.getChild("left_back_leg");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(SpaceMossBugEntity spaceMossBug, float v, float v1, float v2, float v3, float v4) {
        float y = Mth.cos((float)(v * 0.5f)) * 1.2f * v1;
        float yReverse = Mth.cos((float)(v * 0.5f + (float)Math.PI)) * 1.2f * v1;
        this.right_front_leg.yRot = y;
        this.right_middle_leg.yRot = yReverse;
        this.right_back_leg.yRot = y;
        this.left_front_leg.yRot = y;
        this.left_middle_leg.yRot = yReverse;
        this.left_back_leg.yRot = y;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition front_carapace = partdefinition.addOrReplaceChild("front_carapace", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition back_carapace = partdefinition.addOrReplaceChild("back_carapace", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -4.0f, 2.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition right_antenna = partdefinition.addOrReplaceChild("right_antenna", CubeListBuilder.create().texOffs(36, -5).addBox(-2.0f, -10.0f, -6.0f, 0.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition left_antenna = partdefinition.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(36, 1).mirror().addBox(2.0f, -10.0f, -6.0f, 0.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition telson = partdefinition.addOrReplaceChild("telson", CubeListBuilder.create().texOffs(-8, 31).addBox(-3.0f, -4.0f, 5.0f, 6.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition right_front_leg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(-4, 19).addBox(-8.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)23.0f, (float)-5.0f, (float)0.1409f, (float)-0.3855f, (float)-0.1112f));
        PartDefinition right_middle_leg = partdefinition.addOrReplaceChild("right_middle_leg", CubeListBuilder.create().texOffs(-4, 23).addBox(-8.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)23.0f, (float)-3.0f, (float)-0.0339f, (float)0.0499f, (float)-0.1122f));
        PartDefinition right_back_leg = partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(-4, 27).addBox(-8.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)23.0f, (float)0.0f, (float)-0.0955f, (float)0.5713f, (float)-0.1652f));
        PartDefinition left_front_leg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(12, 19).mirror().addBox(0.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)23.0f, (float)-5.0f, (float)0.1409f, (float)0.3855f, (float)0.1112f));
        PartDefinition left_middle_leg = partdefinition.addOrReplaceChild("left_middle_leg", CubeListBuilder.create().texOffs(12, 23).mirror().addBox(0.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)23.0f, (float)-3.0f, (float)-0.0339f, (float)-0.0499f, (float)0.1122f));
        PartDefinition left_back_leg = partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(12, 27).mirror().addBox(0.0f, 0.0f, -2.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)23.0f, (float)0.0f, (float)-0.0955f, (float)-0.5713f, (float)0.1652f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

