/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityMGUSpawnerRenderer
implements BlockEntityRenderer<TileEntityMGUSpawner> {
    public TileEntityMGUSpawnerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TileEntityMGUSpawner tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.hasLevel()) {
            return;
        }
        if (tile.isOn && tile.hasSpawnEggItem() && tile.getEntityToRender() != null) {
            float ticks = (float)tile.animationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
            Entity entity = tile.getEntityToRender();
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.75, 0.5);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            matrixStack.mulPose(Axis.YP.rotationDegrees(ticks));
            matrixStack.scale(0.125f, 0.125f, 0.125f);
            Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        if (!tile.showRenderBox) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(-5.0E-4, -5.0E-4, -5.0E-4);
        matrixStack.scale(0.999f, 0.999f, 0.999f);
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)tile.getAABBForRender(), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        matrixStack.popPose();
    }

    public AABB getRenderBoundingBox(TileEntityMGUSpawner blockEntity) {
        return blockEntity.getAABBWithModifiers();
    }
}

