/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.datagen;

import com.thevortex.allthetweaks.datagen.client.BlockStates;
import com.thevortex.allthetweaks.datagen.client.ItemModels;
import com.thevortex.allthetweaks.datagen.server.BlockTags;
import com.thevortex.allthetweaks.datagen.server.CraftingRecipes;
import com.thevortex.allthetweaks.datagen.server.ItemTags;
import com.thevortex.allthetweaks.datagen.server.LootTables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="allthetweaks")
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) throws IOException {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(generator, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(generator, fileHelper));
        BlockTags blockTags = new BlockTags(packOutput, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(packOutput, event.getLookupProvider(), blockTags.contentsGetter(), fileHelper));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        generator.addProvider(event.includeClient(), (DataProvider)new CraftingRecipes(packOutput, event.getLookupProvider()));
    }
}

