/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.cobblegengalore.common.block.entity;

import cy.jdkdigital.cobblegengalore.CobbleGenGalore;
import cy.jdkdigital.cobblegengalore.Config;
import cy.jdkdigital.cobblegengalore.common.block.BlockGenBlock;
import cy.jdkdigital.cobblegengalore.common.recipe.BlockGenRecipe;
import cy.jdkdigital.cobblegengalore.util.RecipeHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BlockGenBlockEntity
extends BlockEntity {
    private RecipeHolder<BlockGenRecipe> recipe;
    private ResourceLocation recipeId;
    private ItemStack internalBuffer = ItemStack.EMPTY;

    public BlockGenBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)CobbleGenGalore.BLOCKGEN_BLOCKENTITY.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockGenBlockEntity blockEntity) {
        if (blockEntity.recipeId != null) {
            Optional loadedRecipe = level.getRecipeManager().byKey(blockEntity.recipeId);
            loadedRecipe.ifPresent(recipeHolder -> blockEntity.setRecipe((RecipeHolder<BlockGenRecipe>)recipeHolder));
            blockEntity.recipeId = null;
        }
        if (level.getGameTime() % (long)Config.tickRate == 0L) {
            if (blockEntity.recipe != null) {
                int consumedAmountRight;
                int n;
                BlockGenRecipe recipe = (BlockGenRecipe)blockEntity.recipe.value();
                Block block = blockEntity.getBlockState().getBlock();
                if (block instanceof BlockGenBlock) {
                    BlockGenBlock block2 = (BlockGenBlock)block;
                    n = block2.modifier;
                } else {
                    n = 1;
                }
                float modifier = (float)n * recipe.speed;
                ItemStack production = recipe.result.copy();
                int maxProduction = (int)((float)production.getCount() * modifier);
                int consumedAmountLeft = recipe.consumeLeft ? 0 : maxProduction;
                int n2 = consumedAmountRight = recipe.consumeRight ? 0 : maxProduction;
                if (recipe.consumeLeft || recipe.consumeRight) {
                    for (Direction dir : Direction.values()) {
                        if (!dir.getAxis().isHorizontal()) continue;
                        BlockState state = RecipeHelper.getStateAtPos(level, blockPos, dir);
                        if (recipe.consumeLeft && state.is(recipe.left.getBlock())) {
                            consumedAmountLeft = RecipeHelper.consumeFluid(level, blockPos, dir, maxProduction, true);
                            consumedAmountRight = recipe.consumeRight ? RecipeHelper.consumeFluid(level, blockPos, dir.getOpposite(), maxProduction, true) : consumedAmountLeft;
                            maxProduction = Math.min(consumedAmountLeft, consumedAmountRight);
                            RecipeHelper.consumeFluid(level, blockPos, dir, maxProduction, false);
                            if (!recipe.consumeRight) break;
                            RecipeHelper.consumeFluid(level, blockPos, dir.getOpposite(), maxProduction, false);
                            break;
                        }
                        if (!recipe.consumeRight || !state.is(recipe.right.getBlock())) continue;
                        consumedAmountRight = RecipeHelper.consumeFluid(level, blockPos, dir, maxProduction, true);
                        consumedAmountLeft = recipe.consumeLeft ? RecipeHelper.consumeFluid(level, blockPos, dir.getOpposite(), maxProduction, true) : consumedAmountRight;
                        maxProduction = Math.min(consumedAmountLeft, consumedAmountRight);
                        RecipeHelper.consumeFluid(level, blockPos, dir, maxProduction, false);
                        if (!recipe.consumeLeft) break;
                        RecipeHelper.consumeFluid(level, blockPos, dir.getOpposite(), maxProduction, false);
                        break;
                    }
                    maxProduction = Math.min(consumedAmountLeft, consumedAmountRight);
                }
                if (maxProduction > 0) {
                    production.setCount(maxProduction);
                    if (ItemStack.isSameItemSameComponents((ItemStack)blockEntity.internalBuffer, (ItemStack)production)) {
                        if (blockEntity.internalBuffer.getCount() < blockEntity.internalBuffer.getMaxStackSize()) {
                            blockEntity.internalBuffer.grow(production.getCount());
                        }
                    } else {
                        blockEntity.internalBuffer = production;
                    }
                }
            }
            IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos.above(), null);
            blockEntity.internalBuffer = ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)blockEntity.internalBuffer, (boolean)false);
        }
        if (level.getGameTime() % 113L == 0L && blockEntity.recipe == null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockEntity.setRecipe(RecipeHelper.getRecipe(serverLevel, blockPos));
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BlockGenBlockEntity blockEntity) {
        if (blockEntity.recipeId != null) {
            Optional loadedRecipe = level.getRecipeManager().byKey(blockEntity.recipeId);
            loadedRecipe.ifPresent(recipeHolder -> blockEntity.setRecipe((RecipeHolder<BlockGenRecipe>)recipeHolder));
            blockEntity.recipeId = null;
        }
    }

    public BlockState getResultBlock() {
        BlockState blockState;
        Item item;
        if (this.recipe != null && (item = ((BlockGenRecipe)this.recipe.value()).result.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockState = blockItem.getBlock().defaultBlockState();
        } else {
            blockState = null;
        }
        return blockState;
    }

    public boolean hasResult() {
        return this.recipe != null;
    }

    public ItemStack getResultItem() {
        return this.recipe != null ? ((BlockGenRecipe)this.recipe.value()).result : null;
    }

    public void setRecipe(RecipeHolder<BlockGenRecipe> recipe) {
        this.recipe = recipe;
        this.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("recipe")) {
            this.recipe = null;
            this.recipeId = ResourceLocation.tryParse((String)tag.getString("recipe"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.recipe != null) {
            tag.putString("recipe", this.recipe.id().toString());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithId(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public ItemStack getBuffer() {
        return this.internalBuffer;
    }

    public void clearBuffer() {
        this.internalBuffer = ItemStack.EMPTY;
    }
}

