/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.toastcontrol;

import dev.shadowsoffire.toastcontrol.BetterToastComponent;
import dev.shadowsoffire.toastcontrol.ToastConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toastcontrol", dist={Dist.CLIENT})
public class ToastControl {
    public static final String MODID = "toastcontrol";
    public static final Logger LOGGER = LogManager.getLogger((String)"toastcontrol");
    public static final KeyMapping CLEAR = new KeyMapping("key.toastcontrol.clear", 74, "key.toastcontrol.category");
    public static final List<Class<?>> BLOCKED_CLASSES = new ArrayList();
    public static List<BetterToastComponent.BetterToastInstance<?>> tracker = new ArrayList();

    public ToastControl(IEventBus bus, ModContainer container) {
        bus.register((Object)this);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ToastConfig.SPEC);
        bus.register(ToastConfig.class);
        NeoForge.EVENT_BUS.register(Events.class);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        Minecraft.getInstance().toast = new BetterToastComponent();
        ToastControl.handleToastReloc();
        ToastControl.handleBlockedClasses();
    }

    @SubscribeEvent
    public void keyReg(RegisterKeyMappingsEvent e) {
        e.register(CLEAR);
    }

    static void handleToastReloc() {
        ResourceLocation[] targets = new ResourceLocation[]{AdvancementToast.BACKGROUND_SPRITE, RecipeToast.BACKGROUND_SPRITE, SystemToast.BACKGROUND_SPRITE, TutorialToast.BACKGROUND_SPRITE};
        if (ToastConfig.isTextureTransparent()) {
            for (ResourceLocation t : targets) {
                ToastControl.change(t, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"toast/transparent"));
            }
        } else if (ToastConfig.isTextureTranslucent()) {
            String[] paths = new String[]{"advancement", "recipe", "system", "tutorial"};
            for (int i = 0; i < 4; ++i) {
                ToastControl.change(targets[i], ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("toast/translucent/" + paths[i])));
            }
        } else {
            String[] paths = new String[]{"advancement", "recipe", "system", "tutorial"};
            for (int i = 0; i < 4; ++i) {
                ToastControl.change(targets[i], ResourceLocation.withDefaultNamespace((String)("toast/" + paths[i])));
            }
        }
    }

    static void handleBlockedClasses() {
        BLOCKED_CLASSES.clear();
        for (String s : (List)ToastConfig.INSTANCE.blockedClasses.get()) {
            try {
                Class<?> c = Class.forName(s);
                BLOCKED_CLASSES.add(c);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Invalid class string provided to toast control: " + s);
            }
        }
    }

    private static void change(ResourceLocation a, ResourceLocation b) {
        ObfuscationReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.getNamespace(), (String)"namespace");
        ObfuscationReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.getPath(), (String)"path");
    }

    public static class Events {
        @SubscribeEvent
        public static void keys(InputEvent.Key e) {
            if (CLEAR.isDown()) {
                Minecraft.getInstance().getToasts().clear();
            }
        }

        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post e) {
            tracker.removeIf(BetterToastComponent.BetterToastInstance::tick);
        }
    }
}

