/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.huntercamp;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.TentBlockEntity;
import de.teamlapen.vampirism.blocks.FirePlaceBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.blocks.TentMainBlock;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class HunterCampPieces
extends StructurePiece {
    protected final BlockPos pos;

    public static void addStartPieces(@NotNull StructurePiecesBuilder structurePiecesBuilder, @NotNull RandomSource random, BlockPos pos) {
        Fireplace hunterCamp = new Fireplace(random, pos);
        structurePiecesBuilder.addPiece((StructurePiece)hunterCamp);
        hunterCamp.addChildren(hunterCamp, (StructurePieceAccessor)structurePiecesBuilder, random);
    }

    public HunterCampPieces(@NotNull StructurePieceType structurePieceType, int part, BlockPos pos) {
        super(structurePieceType, part, new BoundingBox(pos.getX() - 1, pos.getY(), pos.getZ() - 1, pos.getX() + 1, pos.getY() + 2, pos.getZ() + 1));
        this.pos = pos;
    }

    public HunterCampPieces(@NotNull StructurePieceType structurePieceType, @NotNull CompoundTag nbt) {
        super(structurePieceType, nbt);
        this.pos = new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
        tagCompound.putInt("x", this.pos.getX());
        tagCompound.putInt("y", this.pos.getY());
        tagCompound.putInt("z", this.pos.getZ());
    }

    protected boolean testPreconditions(@NotNull WorldGenLevel worldIn, @NotNull StructureManager manager, @NotNull ChunkPos chunkPos) {
        if (!((Boolean)VampirismConfig.COMMON.enableHunterTentGeneration.get()).booleanValue()) {
            return false;
        }
        return UtilLib.getStructureStartAt((Level)worldIn.getLevel(), this.pos, (TagKey<Structure>)StructureTags.VILLAGE).isEmpty();
    }

    public static class Fireplace
    extends HunterCampPieces {
        boolean specialComponentAdd = false;
        private boolean advanced;

        public Fireplace(@NotNull RandomSource random, BlockPos pos) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_FIREPLACE.get(), 0, pos);
            this.setOrientation(Direction.Plane.HORIZONTAL.getRandomDirection(random));
        }

        public Fireplace(@NotNull CompoundTag nbt) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_FIREPLACE.get(), nbt);
            this.advanced = nbt.getBoolean("advanced");
            this.specialComponentAdd = nbt.getBoolean("specialComponentAdd");
        }

        public void addChildren(@NotNull StructurePiece componentInt, @NotNull StructurePieceAccessor listIn, @NotNull RandomSource rand) {
            @NotNull ArrayList directions = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
            if (rand.nextInt(3) == 0) {
                this.advanced = true;
                listIn.addPiece(this.getTentComponent(rand, directions, true));
                listIn.addPiece(this.getTentComponent(rand, directions, false));
                int i = rand.nextInt(4);
                if (i < 2) {
                    listIn.addPiece(this.getComponent(rand, directions, true));
                }
                if (i < 1) {
                    listIn.addPiece(this.getComponent(rand, directions, true));
                }
            } else {
                listIn.addPiece(this.getTentComponent(rand, directions, false));
                if (rand.nextInt(2) == 0) {
                    listIn.addPiece(this.getComponent(rand, directions, false));
                }
            }
        }

        public void postProcess(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            this.placeBlock(worldIn, (Boolean)VampirismConfig.COMMON.useVanillaCampfire.get() != false ? Blocks.CAMPFIRE.defaultBlockState() : ((FirePlaceBlock)((Object)ModBlocks.FIRE_PLACE.get())).defaultBlockState(), 1, 0, 1, structureBoundingBoxIn);
            this.placeBlock(worldIn, Blocks.AIR.defaultBlockState(), 1, 1, 1, structureBoundingBoxIn);
        }

        @Override
        protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            super.addAdditionalSaveData(context, tagCompound);
            tagCompound.putBoolean("advanced", this.advanced);
            tagCompound.putBoolean("specialComponentAdd", this.specialComponentAdd);
        }

        @NotNull
        private StructurePiece getComponent(@NotNull RandomSource rand, @NotNull List<Direction> directions, boolean advanced) {
            int zOffset;
            int xOffset;
            @NotNull Direction direction = directions.remove(rand.nextInt(directions.size()));
            int n = direction.getAxis().equals((Object)Direction.Axis.X) ? (direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : (xOffset = 0);
            int n2 = direction.getAxis().equals((Object)Direction.Axis.Z) ? (direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : (zOffset = 0);
            if (!this.specialComponentAdd && rand.nextInt(2) == 0) {
                this.specialComponentAdd = true;
                return new SpecialBlock(this.pos.offset(xOffset, 0, zOffset), direction, advanced);
            }
            return new Tent(this.pos.offset(xOffset, 0, zOffset), direction, advanced);
        }

        @NotNull
        private StructurePiece getTentComponent(@NotNull RandomSource rand, @NotNull List<Direction> directions, boolean advanced) {
            int xOffset;
            @NotNull Direction direction = directions.remove(rand.nextInt(directions.size()));
            int n = direction.getAxis().equals((Object)Direction.Axis.X) ? (direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : (xOffset = 0);
            int zOffset = direction.getAxis().equals((Object)Direction.Axis.Z) ? (direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0;
            return new Tent(this.pos.offset(xOffset, 0, zOffset), direction, advanced);
        }
    }

    public static class SpecialBlock
    extends HunterCampPieces {
        private final Direction direction;
        private final boolean advanced;

        public SpecialBlock(BlockPos pos, Direction direction, boolean advanced) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_SPECIAL.get(), 2, pos);
            this.setOrientation(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public SpecialBlock(@NotNull CompoundTag compoundNBT) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_SPECIAL.get(), compoundNBT);
            this.direction = Direction.from2DDataValue((int)compoundNBT.getInt("dir"));
            this.advanced = compoundNBT.getBoolean("advanced");
        }

        public void postProcess(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            if (this.advanced) {
                this.placeBlock(worldIn, ((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).defaultBlockState(), 2, 0, 1, structureBoundingBoxIn);
                this.placeBlock(worldIn, Blocks.CRAFTING_TABLE.defaultBlockState(), 0, 0, 1, structureBoundingBoxIn);
            } else {
                this.placeBlock(worldIn, Blocks.CRAFTING_TABLE.defaultBlockState(), 1, 0, 1, structureBoundingBoxIn);
            }
        }

        @Override
        protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            super.addAdditionalSaveData(context, tagCompound);
            tagCompound.putInt("dir", this.direction.get2DDataValue());
            tagCompound.putBoolean("advanced", this.advanced);
        }
    }

    public static class Tent
    extends HunterCampPieces {
        @NotNull
        private final Direction direction;
        private final boolean advanced;
        int xDiff;
        int xCenter;
        private int mirror;

        public Tent(BlockPos pos, @NotNull Direction direction, boolean advanced) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_TENT.get(), 1, pos);
            this.setOrientation(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public Tent(@NotNull CompoundTag nbt) {
            super((StructurePieceType)ModStructures.HUNTER_CAMP_TENT.get(), nbt);
            this.direction = Direction.from2DDataValue((int)nbt.getInt("direction"));
            this.mirror = nbt.getInt("mirror");
            this.advanced = nbt.getBoolean("advanced");
        }

        public void postProcess(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            int d;
            int c;
            int b;
            int a;
            if (this.mirror == 0 ? (this.mirror = random.nextInt(2) + 1) == 1 : this.mirror == 1) {
                this.xDiff = 2;
                this.xCenter = this.pos.getX() + 1;
            } else {
                this.xDiff = 0;
                this.xCenter = this.pos.getX() - 1;
            }
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            Direction dir = this.direction == Direction.SOUTH || this.direction == Direction.WEST ? this.direction.getOpposite() : this.direction;
            int nul = this.direction.get2DDataValue() % 4;
            int one = (this.direction.get2DDataValue() + 1) % 4;
            int two = (this.direction.get2DDataValue() + 2) % 4;
            int three = (this.direction.get2DDataValue() + 3) % 4;
            boolean positiveAxisDirection = this.direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE);
            boolean xAxis = this.direction.getAxis().equals((Object)Direction.Axis.X);
            int n = positiveAxisDirection ? one : (a = xAxis ? nul : two);
            int n2 = !positiveAxisDirection ? three : (b = xAxis ? two : nul);
            int n3 = positiveAxisDirection ? three : (c = xAxis ? two : nul);
            int n4 = !positiveAxisDirection ? one : (d = xAxis ? nul : two);
            if (this.mirror == 1) {
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), 1, 0, 0, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentMainBlock)((Object)ModBlocks.TENT_MAIN.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), 1, 0, 1, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), this.xDiff, 0, 1, structureBoundingBoxIn);
            } else {
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), 1, 0, 0, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentMainBlock)((Object)ModBlocks.TENT_MAIN.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), 1, 0, 1, structureBoundingBoxIn);
                this.placeBlock(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), this.xDiff, 0, 1, structureBoundingBoxIn);
            }
            BlockEntity tile = worldIn.getBlockEntity(this.pos);
            if (tile instanceof TentBlockEntity) {
                ((TentBlockEntity)tile).setSpawn(true);
                if (this.advanced) {
                    ((TentBlockEntity)tile).setAdvanced(true);
                }
            }
            BlockState air = Blocks.AIR.defaultBlockState();
            this.placeBlock(worldIn, air, 1, 0, -1, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, this.xDiff, 0, -1, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, 1, 1, -1, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, this.xDiff, 1, -1, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, this.xDiff, 1, 0, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, 1, 1, 0, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, 1, 1, 1, structureBoundingBoxIn);
            this.placeBlock(worldIn, air, this.xDiff, 1, 1, structureBoundingBoxIn);
            if (worldIn.getBlockState(this.pos.offset(0, -1, -2)).is(BlockTags.DIRT)) {
                this.placeBlock(worldIn, Blocks.GRASS_BLOCK.defaultBlockState(), 1, -1, -1, structureBoundingBoxIn);
            }
            if (worldIn.getBlockState(this.atX(this.pos.offset(0, -1, -2), this.xCenter)).is(BlockTags.DIRT)) {
                this.placeBlock(worldIn, Blocks.GRASS_BLOCK.defaultBlockState(), this.xDiff, -1, -1, structureBoundingBoxIn);
            }
        }

        private BlockPos atX(BlockPos pos, int newX) {
            return new BlockPos(newX, pos.getY(), pos.getZ());
        }

        @Override
        protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            tagCompound.putInt("direction", this.direction.get2DDataValue());
            tagCompound.putInt("mirror", this.mirror);
            tagCompound.putBoolean("advanced", this.advanced);
            super.addAdditionalSaveData(context, tagCompound);
        }
    }
}

