/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.random.Weight;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import org.jetbrains.annotations.NotNull;

public record ExtendedAddSpawnsBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> excludedBiomes, List<ExtendedSpawnData> spawners) implements BiomeModifier
{
    public static final MapCodec<ExtendedAddSpawnsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ExtendedAddSpawnsBiomeModifier::biomes), (App)Biome.LIST_CODEC.fieldOf("excludedBiomes").forGetter(ExtendedAddSpawnsBiomeModifier::excludedBiomes), (App)Codec.either((Codec)ExtendedSpawnData.CODEC.listOf(), ExtendedSpawnData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((Object)((ExtendedSpawnData)((Object)((Object)((Object)list.getFirst())))))) : Either.left((Object)list)).fieldOf("spawners").forGetter(ExtendedAddSpawnsBiomeModifier::spawners)).apply((Applicative)builder, ExtendedAddSpawnsBiomeModifier::new));

    @NotNull
    public static ExtendedAddSpawnsBiomeModifier singleSpawn(HolderSet<Biome> biomes, HolderSet<Biome> excludedBiomes, @NotNull ExtendedSpawnData spawner) {
        return new ExtendedAddSpawnsBiomeModifier(biomes, excludedBiomes, List.of(spawner));
    }

    public void modify(@NotNull Holder<Biome> biome, BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome) && !this.excludedBiomes.contains(biome)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (ExtendedSpawnData spawner : this.spawners) {
                spawns.addSpawn(spawner.category, (MobSpawnSettings.SpawnerData)spawner);
            }
        }
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public static class ExtendedSpawnData
    extends MobSpawnSettings.SpawnerData {
        public static final Codec<ExtendedSpawnData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("super").forGetter(b -> b), (App)MobCategory.CODEC.fieldOf("category").forGetter(b -> b.category)).apply((Applicative)builder, ExtendedSpawnData::new));
        private final MobCategory category;

        public ExtendedSpawnData(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull MobSpawnSettings.SpawnerData data, MobCategory category) {
            super(data.type, data.getWeight(), data.minCount, data.maxCount);
            this.category = category;
        }

        public ExtendedSpawnData(@NotNull EntityType<?> type, int weight, int minCount, int maxCount, MobCategory category) {
            super(type, weight, minCount, maxCount);
            this.category = category;
        }

        public ExtendedSpawnData(@NotNull EntityType<?> type, @NotNull Weight weight, int minCount, int maxCount, MobCategory category) {
            super(type, weight, minCount, maxCount);
            this.category = category;
        }
    }
}

