/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import de.teamlapen.vampirism.core.ModAttachments;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LevelGarlic
implements IGarlicChunkHandler {
    private final HashMap<ChunkPos, EnumStrength> strengthHashMap = Maps.newHashMap();
    private final HashMap<Integer, Emitter> emitterHashMap = Maps.newHashMap();

    @Deprecated
    public static Optional<LevelGarlic> getOpt(@NotNull Level level) {
        return Optional.of((LevelGarlic)level.getData(ModAttachments.LEVEL_GARLIC));
    }

    public static LevelGarlic get(@NotNull Level level) {
        return (LevelGarlic)level.getData(ModAttachments.LEVEL_GARLIC);
    }

    @Override
    @NotNull
    public EnumStrength getStrengthAtChunk(ChunkPos pos) {
        EnumStrength s = this.strengthHashMap.get(pos);
        return s == null ? EnumStrength.NONE : s;
    }

    @Override
    public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
        for (ChunkPos p : pos) {
            if (p != null) continue;
            throw new IllegalArgumentException("Garlic emitter position should not be null");
        }
        Emitter e = new Emitter(strength, pos);
        int hash = e.hashCode();
        this.emitterHashMap.putIfAbsent(hash, e);
        this.rebuildStrengthMap();
        return hash;
    }

    @Override
    public void removeGarlicBlock(int id) {
        Emitter e = this.emitterHashMap.remove(id);
        this.rebuildStrengthMap();
    }

    private void rebuildStrengthMap() {
        this.strengthHashMap.clear();
        for (Emitter e : this.emitterHashMap.values()) {
            for (ChunkPos pos : e.pos) {
                EnumStrength old = this.strengthHashMap.get(pos);
                if (old != null && !e.strength.isStrongerThan(old)) continue;
                this.strengthHashMap.put(pos, e.strength);
            }
        }
    }

    public void printDebug(@NotNull CommandSourceStack sender) {
        for (Emitter emitter : this.emitterHashMap.values()) {
            sender.sendSuccess(() -> Component.literal((String)("E: " + emitter.toString())), true);
        }
        for (Map.Entry entry : this.strengthHashMap.entrySet()) {
            sender.sendSuccess(() -> Component.literal((String)("S: " + entry.toString())), true);
        }
    }

    @Override
    public void clearCache() {
        this.strengthHashMap.clear();
        this.emitterHashMap.clear();
    }

    private record Emitter(EnumStrength strength, ChunkPos[] pos) {
    }
}

